/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.DataBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.RowBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetScope;
import org.bonitasoft.web.designer.model.data.Data;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;

public class PageBuilder {
    private List<List<Element>> rows = new ArrayList<List<Element>>();
    private Set<Asset> assets = new HashSet<Asset>();
    private Set<String> inactiveAssets = new HashSet<String>();
    @Deprecated
    private Map<String, Data> data = null;
    private Map<String, Variable> variables = new HashMap<String, Variable>();
    private String name = "pageName";
    private String id = UUID.randomUUID().toString();
    private String uuid = UUID.randomUUID().toString();
    private String designerVersion;
    private String modelVersion;
    private String previousDesignerVersion;
    private String previousArtifactVersion;
    private boolean favorite = false;
    private String type;
    private MigrationStatusReport migrationStatusReport = new MigrationStatusReport();

    private PageBuilder() {
    }

    public static PageBuilder aPage() {
        return new PageBuilder();
    }

    public PageBuilder with(Element ... elements) {
        this.rows.add(Arrays.asList(elements));
        return this;
    }

    public PageBuilder with(ElementBuilder ... elements) {
        this.rows.add(Lists.newArrayList((Iterable)Lists.transform(Arrays.asList(elements), (Function)new Function<ElementBuilder, Element>(){

            public Element apply(ElementBuilder elementBuilder) {
                return elementBuilder.build();
            }
        })));
        return this;
    }

    public PageBuilder withAsset(Asset ... assets) {
        for (Asset asset : assets) {
            this.assets.add(asset);
        }
        return this;
    }

    public PageBuilder withAsset(AssetBuilder ... assets) {
        for (AssetBuilder asset : assets) {
            this.assets.add(asset.build());
        }
        return this;
    }

    public PageBuilder withInactiveAsset(String ... assetIds) {
        for (String id : assetIds) {
            this.inactiveAssets.add(id);
        }
        return this;
    }

    @Deprecated
    public PageBuilder withData(String name, Data data) {
        this.variables.put(name, this.convertDataToVariable(data));
        return this;
    }

    private Variable convertDataToVariable(Data data) {
        String variableValue = Objects.toString(data.getValue(), null);
        Variable variable = new Variable(data.getType(), variableValue);
        variable.setExposed(data.isExposed());
        return variable;
    }

    @Deprecated
    public PageBuilder withData(String name, DataBuilder data) {
        return this.withData(name, data.build());
    }

    public PageBuilder withVariable(String name, Variable variable) {
        this.variables.put(name, variable);
        return this;
    }

    public PageBuilder withVariable(String name, VariableBuilder variableBuilder) {
        return this.withVariable(name, variableBuilder.build());
    }

    public PageBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public PageBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public PageBuilder withUUID(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public PageBuilder withDesignerVersion(String version) {
        this.designerVersion = version;
        return this;
    }

    public PageBuilder withModelVersion(String version) {
        this.modelVersion = version;
        return this;
    }

    public PageBuilder withPreviousArtifactVersion(String previousArtifactVersion) {
        this.previousArtifactVersion = previousArtifactVersion;
        return this;
    }

    public PageBuilder withPreviousDesignerVersion(String previousArtifactVersion) {
        this.previousDesignerVersion = previousArtifactVersion;
        return this;
    }

    public PageBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public PageBuilder favorite() {
        this.favorite = true;
        return this;
    }

    public PageBuilder notFavorite() {
        this.favorite = false;
        return this;
    }

    public PageBuilder withMigrationStatusReport(MigrationStatusReport migrationStatusReport) {
        this.migrationStatusReport = migrationStatusReport;
        return this;
    }

    public PageBuilder isCompatible(boolean compatible) {
        this.migrationStatusReport.setCompatible(compatible);
        return this;
    }

    public PageBuilder isMigration(boolean migration) {
        this.migrationStatusReport.setMigration(migration);
        return this;
    }

    public Page build() {
        Page page = new Page();
        page.setName(this.name);
        page.setRows(this.rows);
        page.setData(this.data);
        page.setVariables(this.variables);
        page.setId(this.id);
        page.setUUID(this.uuid);
        page.setAssets(this.assets);
        page.setInactiveAssets(this.inactiveAssets);
        page.setDesignerVersion(this.designerVersion);
        page.setModelVersion(this.modelVersion);
        if (this.previousArtifactVersion != null) {
            page.setPreviousArtifactVersion(this.previousArtifactVersion);
        } else {
            page.setPreviousDesignerVersion(this.previousDesignerVersion);
        }
        page.setStatus(this.migrationStatusReport);
        page.setFavorite(this.favorite);
        if (this.type != null) {
            page.setType(this.type);
        }
        return page;
    }

    public static Page aFilledPage(String id) throws Exception {
        RowBuilder row = RowBuilder.aRow().with(ComponentBuilder.aParagraph().withPropertyValue("content", "hello <br/> world").withDimension(6), ComponentBuilder.anInput().withDescription("A mandatory name input").withPropertyValue("required", false).withPropertyValue("placeholder", "enter you're name").withDimension(6));
        Container containerWithTwoRows = ContainerBuilder.aContainer().with(row, row).build();
        TabContainer tabContainer = new TabContainer();
        tabContainer.setContainer(containerWithTwoRows);
        TabContainer tabContainer2 = new TabContainer();
        tabContainer2.setContainer(containerWithTwoRows);
        TabsContainer tabsContainer = new TabsContainer();
        tabsContainer.setTabList(Arrays.asList(tabContainer, tabContainer2));
        FormContainer formContainer = new FormContainer();
        formContainer.setContainer(ContainerBuilder.aContainer().with(ComponentBuilder.aParagraph().withPropertyValue("content", "hello <br/> world").withDimension(6)).build());
        return PageBuilder.aPage().withId(id).with(new Element[]{tabsContainer, containerWithTwoRows, formContainer}).withAsset(AssetBuilder.anAsset().withName("asset.js").withScope(AssetScope.PAGE).build()).withVariable("aVariable", VariableBuilder.aConstantVariable().value("a value")).withVariable("anotherVariable", VariableBuilder.aConstantVariable().value("4")).build();
    }
}

