/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import java.net.URISyntaxException;
import org.bonitasoft.web.designer.builder.BusinessObjectBuilder;
import org.bonitasoft.web.designer.controller.UiGenerationResource;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.BusinessObject;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.DataManagementGenerator;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.NodeBusinessObjectInput;
import org.bonitasoft.web.designer.utils.RestControllerUtil;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@RunWith(value=MockitoJUnitRunner.class)
public class UiGenerationResourceTest {
    private MockMvc mockMvc;
    @InjectMocks
    private UiGenerationResource UiGenerationResource;
    @Mock
    private DataManagementGenerator dataManagementGenerator;

    @Before
    public void setUp() throws URISyntaxException {
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.UiGenerationResource).build();
    }

    @Test
    public void should_generate_business_object_ui() throws Exception {
        BusinessObject bo = BusinessObjectBuilder.aBusinessObject().withNodeBusinessObjectInput(new NodeBusinessObjectInput("com_company_model_address", "address")).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/generation/businessobject", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(bo))).andExpect(MockMvcResultMatchers.status().isOk());
        ((DataManagementGenerator)Mockito.verify((Object)this.dataManagementGenerator)).generate((BusinessObject)Matchers.any(BusinessObject.class));
    }
}

