/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import com.jayway.jsonassert.impl.matcher.IsCollectionWithSize;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PropertyBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.controller.WidgetResource;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.repository.exception.NotAllowedException;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.utils.RestControllerUtil;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.bonitasoft.web.designer.visitor.AssetVisitor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.joda.time.Instant;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.web.multipart.MultipartFile;

public class WidgetResourceTest {
    private MockMvc mockMvc;
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    WidgetService widgetService;
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private PageRepository pageRepository;
    @Mock
    private AssetService<Widget> widgetAssetService;
    private Path widgetRepositoryPath;
    private AssetVisitor assetVisitor;

    public WidgetResourceTest() {
        this.assetVisitor = new AssetVisitor(this.widgetRepository, this.fragmentRepository);
    }

    @Before
    public void setUp() throws URISyntaxException {
        MockitoAnnotations.initMocks((Object)this);
        this.widgetRepositoryPath = Paths.get(this.getClass().getResource("/workspace/widgets").toURI());
        WidgetResource widgetResource = new WidgetResource(new DesignerConfig().objectMapperWrapper(), this.widgetRepository, this.widgetService, this.widgetAssetService, this.widgetRepositoryPath, Arrays.asList(this.pageRepository, this.fragmentRepository), this.assetVisitor);
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(widgetResource).build();
        Mockito.when((Object)this.widgetRepository.getComponentName()).thenReturn((Object)"widget");
        Mockito.when((Object)this.pageRepository.getComponentName()).thenReturn((Object)"page");
        Mockito.when((Object)this.fragmentRepository.getComponentName()).thenReturn((Object)"fragment");
    }

    @Test
    public void should_serve_all_widgets_in_repository() throws Exception {
        Widget input = WidgetBuilder.aWidget().id("input").build();
        Widget label = WidgetBuilder.aWidget().id("label").build();
        Mockito.when((Object)this.widgetRepository.getAll()).thenReturn(Arrays.asList(input, label));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].id", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"input", "label"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].type", (Object[])new Object[0]).value(CoreMatchers.everyItem((Matcher)CoreMatchers.is((Object)"widget"))));
    }

    @Test
    public void should_serve_empty_list_if_widget_repository_is_empty() throws Exception {
        Mockito.when((Object)this.widgetRepository.getAll()).thenReturn(new ArrayList());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)0)));
    }

    @Test
    public void should_respond_500_internal_server_error_if_an_error_occurs_while_getting_widgets() throws Exception {
        Mockito.when((Object)this.widgetRepository.getAll()).thenThrow(new Throwable[]{new RepositoryException("error occurs", (Throwable)new Exception())});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(500));
    }

    @Test
    public void should_get_a_widget_by_its_id() throws Exception {
        Widget input = WidgetBuilder.aWidget().id("input").build();
        Mockito.when((Object)this.widgetService.get("input")).thenReturn((Object)input);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/input", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().json(this.toJson(input)));
    }

    @Test
    public void should_get_a_widget_with_asset_by_its_id() throws Exception {
        Widget input = WidgetBuilder.aWidget().id("input").assets(AssetBuilder.anAsset().withName("myScopeWidgetAsset").withType(AssetType.CSS)).build();
        Mockito.when((Object)this.widgetService.get("input")).thenReturn((Object)input);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/input", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().json(this.toJson(input))).andExpect(MockMvcResultMatchers.jsonPath((String)"assets[*].scope", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"assets[*].scope", (Object[])new Object[0]).value(CoreMatchers.everyItem((Matcher)CoreMatchers.is((Object)"widget"))));
    }

    @Test
    public void should_respond_404_when_getting_an_unexisting_widget() throws Exception {
        Mockito.when((Object)this.widgetService.get("notExistingWidget")).thenThrow(new Throwable[]{new NotFoundException("not found")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/notExistingWidget", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_save_a_widget() throws Exception {
        Widget customLabel = WidgetBuilder.aWidget().id("customLabel").custom().build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/customLabel", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(customLabel))).andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).updateLastUpdateAndSave((Identifiable)customLabel);
    }

    @Test
    public void should_not_allow_to_save_a_pb_widget() throws Exception {
        Widget pbWidget = WidgetBuilder.aWidget().custom().build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/pbLabel", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pbWidget))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void should_not_allow_to_save_a_not_custom_widget() throws Exception {
        Widget pbWidget = WidgetBuilder.aWidget().id("input").build();
        Mockito.when((Object)this.widgetService.get("input")).thenReturn((Object)pbWidget);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/customLabel", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pbWidget))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void should_respond_500_internal_server_error_if_an_error_occurs_while_saving_a_widget() throws Exception {
        ((WidgetRepository)Mockito.doThrow((Throwable)new RepositoryException("error occurs", (Throwable)new Exception())).when((Object)this.widgetRepository)).updateLastUpdateAndSave((Identifiable)Matchers.any(Widget.class));
        Widget customLabel = WidgetBuilder.aWidget().id("customLabel").custom().build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/customLabel", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(customLabel))).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_create_a_new_widget() throws Exception {
        Widget customLabel = WidgetBuilder.aWidget().name("label").custom().build();
        Mockito.when((Object)this.widgetRepository.create(customLabel)).thenReturn((Object)customLabel);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(customLabel))).andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).create((Widget)Mockito.notNull(Widget.class));
    }

    @Test
    public void should_duplicate_a_widget_from_a_widget() throws Exception {
        Widget customLabel = WidgetBuilder.aWidget().name("label").assets(AssetBuilder.anAsset().withName("myfile.js")).custom().build();
        Mockito.when((Object)this.widgetRepository.get("my-widget-source")).thenReturn((Object)WidgetBuilder.aWidget().id("my-widget-source").name("label").assets(AssetBuilder.anAsset().withName("myfile.js")).custom().build());
        Mockito.when((Object)this.widgetRepository.create(customLabel)).thenReturn((Object)customLabel);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets?duplicata=my-widget-source", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(customLabel))).andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).create((Widget)Mockito.notNull(Widget.class));
        ((AssetService)Mockito.verify(this.widgetAssetService)).duplicateAsset((Path)Matchers.any(Path.class), (Path)Matchers.any(Path.class), (String)Mockito.eq((Object)"my-widget-source"), Mockito.anyString());
    }

    @Test
    public void should_not_allow_to_create_a_widget_with_an_empty_name() throws Exception {
        Widget customLabel = WidgetBuilder.aWidget().name("").custom().build();
        Mockito.when((Object)this.widgetRepository.create(customLabel)).thenThrow(new Throwable[]{new IllegalArgumentException()});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(customLabel))).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void should_not_allow_to_create_a_widget_with_an_existing_name() throws Exception {
        Widget customLabel = WidgetBuilder.aWidget().name("alreadyExistingName").build();
        Mockito.when((Object)this.widgetRepository.create(customLabel)).thenThrow(new Throwable[]{new NotAllowedException("already existing name")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(customLabel))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void should_delete_a_widget() throws Exception {
        Mockito.when((Object)this.widgetRepository.get("customLabel")).thenReturn((Object)WidgetBuilder.aWidget().custom().id("customLabel").build());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/customLabel", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).delete("customLabel");
    }

    @Test
    public void should_not_allow_to_delete_a_pb_widget() throws Exception {
        Mockito.when((Object)this.widgetRepository.get("pbWidget")).thenReturn((Object)WidgetBuilder.aWidget().id("pbWidget").build());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/pbWidget", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void should_respond_404_if_trying_to_delete_an_unknown_widget() throws Exception {
        Mockito.when((Object)this.widgetRepository.get("customLabel")).thenReturn((Object)WidgetBuilder.aWidget().custom().id("customLabel").build());
        ((WidgetRepository)Mockito.doThrow((Throwable)new NotFoundException("not found")).when((Object)this.widgetRepository)).get("customLabel");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/customLabel", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_not_allow_to_delete_a_custom_widget_used_in_a_page() throws Exception {
        Mockito.when((Object)this.widgetRepository.get("customLabel")).thenReturn((Object)WidgetBuilder.aWidget().custom().id("customLabel").build());
        Mockito.when((Object)this.pageRepository.containsObject("customLabel")).thenReturn((Object)true);
        Mockito.when((Object)this.pageRepository.getArtifactsUsingWidget("customLabel")).thenReturn(Arrays.asList(PageBuilder.aPage().withName("person").build()));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/customLabel", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isConflict()).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"The widget cannot be deleted because it is used in 1 page, <person>"));
    }

    @Test
    public void should_respond_404_not_found_if_custom_widget_is_not_existing_when_renaming() throws Exception {
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenThrow(new Throwable[]{new NotFoundException("page not found")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/my-widget/name", (Object[])new Object[0]).contentType("application/json").content("hello")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_add_a_property_to_a_widget_and_return_the_list_of_properties() throws Exception {
        Property property = PropertyBuilder.aProperty().build();
        List<Property> expectedProperties = Arrays.asList(property);
        Mockito.when((Object)this.widgetRepository.addProperty("customLabel", property)).thenReturn(expectedProperties);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets/customLabel/properties", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(property))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().json(this.toJson(expectedProperties)));
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).addProperty("customLabel", property);
    }

    @Test
    public void should_not_allow_to_add_a_property_to_a_pb_widget() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets/pbLabel/properties", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void should_respond_404_when_adding_a_property_to_an_unexisting_widget() throws Exception {
        Mockito.when((Object)this.widgetRepository.addProperty((String)Mockito.eq((Object)"unknownWidget"), (Property)Matchers.any(Property.class))).thenThrow(new Throwable[]{new NotFoundException("not found")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets/unknownWidget/properties", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_500_when_error_appear_while_saving_property() throws Exception {
        Mockito.when((Object)this.widgetRepository.addProperty((String)Mockito.eq((Object)"label"), (Property)Matchers.any(Property.class))).thenThrow(new Class[]{RepositoryException.class});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets/label/properties", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_update_a_property_of_a_widget_and_return_the_list_of_properties() throws Exception {
        Property property = PropertyBuilder.aProperty().build();
        List<Property> expectedProperties = Arrays.asList(property);
        Mockito.when((Object)this.widgetService.updateProperty("customLabel", "toBeUpdated", property)).thenReturn(expectedProperties);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/customLabel/properties/toBeUpdated", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(property))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().json(this.toJson(expectedProperties)));
        ((WidgetService)Mockito.verify((Object)this.widgetService)).updateProperty("customLabel", "toBeUpdated", property);
    }

    @Test
    public void should_not_allow_to_update_a_property_of_a_pb_widget() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/pbLabel/properties/toBeUpdated", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void should_respond_404_when_widget_or_property_not_found_while_updating_property() throws Exception {
        Mockito.when((Object)this.widgetService.updateProperty((String)Mockito.eq((Object)"label"), (String)Mockito.eq((Object)"toBeUpdated"), (Property)Matchers.any(Property.class))).thenThrow(new Class[]{NotFoundException.class});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/label/properties/toBeUpdated", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_500_when_error_appear_while_updating_property() throws Exception {
        Mockito.when((Object)this.widgetService.updateProperty((String)Mockito.eq((Object)"label"), (String)Mockito.eq((Object)"toBeUpdated"), (Property)Matchers.any(Property.class))).thenThrow(new Class[]{RepositoryException.class});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/label/properties/toBeUpdated", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_delete_a_property_of_a_widget_and_return_the_list_of_properties() throws Exception {
        Property property = PropertyBuilder.aProperty().build();
        List<Property> expectedProperties = Arrays.asList(property);
        Mockito.when((Object)this.widgetRepository.deleteProperty("customLabel", "toBeDeleted")).thenReturn(expectedProperties);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/customLabel/properties/toBeDeleted", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(property))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().json(this.toJson(expectedProperties)));
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).deleteProperty("customLabel", "toBeDeleted");
    }

    @Test
    public void should_not_allow_to_delete_a_property_of_a_pb_widget() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/pbLabel/properties/toBeDeleted", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isForbidden()).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Not allowed to modify a non custom widgets"));
    }

    @Test
    public void should_respond_404_when_widget_or_property_not_found_while_deleting_property() throws Exception {
        Mockito.when((Object)this.widgetRepository.deleteProperty("label", "toBeDeleted")).thenThrow(new Throwable[]{new NotFoundException("Widget [ toBeDeleted ] not found")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/label/properties/toBeDeleted", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Widget [ toBeDeleted ] not found"));
    }

    @Test
    public void should_respond_500_when_error_appear_while_deleting_property() throws Exception {
        Mockito.when((Object)this.widgetRepository.deleteProperty("label", "toBeDeleted")).thenThrow(new Class[]{RepositoryException.class});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/label/properties/toBeDeleted", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(PropertyBuilder.aProperty().build()))).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_upload_a_local_asset() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.js", "application/javascript", "foo".getBytes());
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Asset expectedAsset = AssetBuilder.anAsset().withId("assetId").active().withName("myfile.js").withOrder(2).withType(AssetType.JAVASCRIPT).build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetAssetService.upload((MultipartFile)file, (Assetable)widget, "js")).thenReturn((Object)expectedAsset);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/rest/widgets/my-widget/assets/js", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Object[])new Object[0]).value((Object)"assetId")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"myfile.js")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Object[])new Object[0]).value((Object)"js")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.order", (Object[])new Object[0]).value((Object)2));
        ((AssetService)Mockito.verify(this.widgetAssetService)).upload((MultipartFile)file, (Assetable)widget, "js");
    }

    @Test
    public void should_not_upload_an_asset() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.js", "application/javascript", "foo".getBytes());
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        ((AssetService)Mockito.doThrow(IllegalArgumentException.class).when(this.widgetAssetService)).upload((MultipartFile)file, (Assetable)widget, "js");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/rest/widgets/my-widget/assets/js", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((AssetService)Mockito.verify(this.widgetAssetService)).upload((MultipartFile)file, (Assetable)widget, "js");
    }

    @Test
    public void should_not_upload_an_asset_for_custom_widget() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.js", "application/javascript", "foo".getBytes());
        Widget widget = WidgetBuilder.aWidget().id("my-widget").build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        ((AssetService)Mockito.doThrow(IllegalArgumentException.class).when(this.widgetAssetService)).upload((MultipartFile)file, (Assetable)widget, "js");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/rest/widgets/my-widget/assets/js", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void should_save_an_external_asset() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Asset expectedAsset = AssetBuilder.anAsset().withId("assetId").active().withName("myfile.js").withOrder(2).withType(AssetType.JAVASCRIPT).build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetAssetService.save((Assetable)widget, expectedAsset)).thenReturn((Object)expectedAsset);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets/my-widget/assets", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(expectedAsset))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Object[])new Object[0]).value((Object)"assetId")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"myfile.js")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Object[])new Object[0]).value((Object)"js")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.order", (Object[])new Object[0]).value((Object)2));
        ((AssetService)Mockito.verify(this.widgetAssetService)).save((Assetable)widget, expectedAsset);
    }

    @Test
    public void should_not_save_an_external_asset_for_internal_widget() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("pb-widget").build();
        Asset asset = AssetBuilder.anAsset().build();
        Mockito.when((Object)this.widgetRepository.get("pb-widget")).thenReturn((Object)widget);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets/pb-widget/assets", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(asset))).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void should_not_save_an_external_asset_when_upload_send_an_error() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Asset asset = AssetBuilder.anAsset().build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        ((AssetService)Mockito.doThrow(IllegalArgumentException.class).when(this.widgetAssetService)).save((Assetable)widget, asset);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/widgets/my-widget/assets", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(asset))).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void should_delete_an_asset() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Asset asset = AssetBuilder.anAsset().withComponentId("my-widget").build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/my-widget/assets/UIID", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((AssetService)Mockito.verify(this.widgetAssetService)).delete((Assetable)widget, "UIID");
    }

    @Test
    public void should_increment_an_asset() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Asset asset = AssetBuilder.anAsset().withComponentId("my-widget").withOrder(3).build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/my-widget/assets/UIID?increment=true", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(asset))).andExpect(MockMvcResultMatchers.status().isOk());
        ((AssetService)Mockito.verify(this.widgetAssetService)).changeAssetOrderInComponent((Assetable)widget, "UIID", AssetService.OrderType.INCREMENT);
    }

    @Test
    public void should_decrement_an_asset() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Asset asset = AssetBuilder.anAsset().withComponentId("my-widget").withOrder(3).build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/my-widget/assets/UIID?decrement=true", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(asset))).andExpect(MockMvcResultMatchers.status().isOk());
        ((AssetService)Mockito.verify(this.widgetAssetService)).changeAssetOrderInComponent((Assetable)widget, "UIID", AssetService.OrderType.DECREMENT);
    }

    @Test
    public void should_mark_a_page_as_favorite() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/my-widget/favorite", (Object[])new Object[0]).contentType("application/json").content("true")).andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).markAsFavorite("my-widget");
    }

    @Test
    public void should_unmark_a_page_as_favorite() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/widgets/my-widget/favorite", (Object[])new Object[0]).contentType("application/json").content("false")).andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).unmarkAsFavorite("my-widget");
    }

    private String toJson(Object o) throws IOException {
        return new String(RestControllerUtil.convertObjectToJsonBytes(o));
    }

    @Test
    public void should_load_widget_asset_on_disk_with_content_type_text() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbLabel/pbLabel.js");
        Mockito.when((Object)this.widgetAssetService.findAssetPath("widget-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenReturn((Object)expectedFile);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/widget-id/assets/js/asset.js?format=text", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"pbLabel.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_download_widget_asset() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbLabel/pbLabel.js");
        Mockito.when((Object)this.widgetAssetService.findAssetPath("widget-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenReturn((Object)expectedFile);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/widget-id/assets/js/asset.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.content().contentType("application/octet-stream")).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename=\"pbLabel.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_respond_404_when_widget_asset_included_in_page_is_not_found() throws Exception {
        Mockito.when((Object)this.widgetAssetService.findAssetPath("widget-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenReturn(null);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/widget-id/assets/js/asset.js?format=text", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/widget-id/assets/js/asset.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_500_when_widget_asset_included_in_page_produce_IOException() throws Exception {
        Mockito.when((Object)this.widgetAssetService.findAssetPath("widget-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenThrow(new Throwable[]{new IOException("can't read file")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/widget-id/assets/js/asset.js?format=text", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/widget-id/assets/js/asset.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @Ignore(value="Test ignored because failed on CI")
    public void should_download_help() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbText/help.html");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/pbText/help", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_HTML)).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"help.html\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_respond_404_when_widget_help_is_not_found() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/pbLabel/help", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_422_when_custom_widget_is_incompatible() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        widget.setStatus(new MigrationStatusReport(false, true));
        Mockito.when((Object)this.widgetService.get("my-widget")).thenReturn((Object)widget);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets/my-widget", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(422));
    }

    @Test
    public void should_serve_all_light_widgets_in_repository() throws Exception {
        Widget input = WidgetBuilder.aWidget().id("input").build();
        Widget label = WidgetBuilder.aWidget().id("label").lastUpdate(Instant.parse((String)"2015-02-02")).build();
        Mockito.when((Object)this.widgetRepository.getAll()).thenReturn(Arrays.asList(input, label));
        String[] ids = new String[]{"input", "label"};
        HashMap<String, List<Page>> map = new HashMap<String, List<Page>>();
        map.put("input", Collections.singletonList(PageBuilder.aPage().withName("hello").build()));
        Mockito.when((Object)this.pageRepository.getArtifactsUsingWidgets(Arrays.asList(ids))).thenReturn(map);
        HashMap<String, List<Fragment>> map2 = new HashMap<String, List<Fragment>>();
        map2.put("label", Collections.singletonList(FragmentBuilder.aFragment().withName("helloFragment").build()));
        Mockito.when((Object)this.fragmentRepository.getArtifactsUsingWidgets(Arrays.asList(ids))).thenReturn(map2);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/widgets?view=light", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].id", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"input", "label"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].lastUpdate", (Object[])new Object[0]).value(IsCollectionContaining.hasItem((Object)Instant.parse((String)"2015-02-02").getMillis()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].usedBy.fragment[*].name", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"helloFragment"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].usedBy.page[*].name", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"hello"})));
    }

    @Test
    public void should_not_allow_to_delete_a_custom_widget_used_in_a_fragment() throws Exception {
        Mockito.when((Object)this.widgetRepository.get("customLabel")).thenReturn((Object)WidgetBuilder.aWidget().custom().id("customLabel").build());
        Mockito.when((Object)this.fragmentRepository.containsObject("customLabel")).thenReturn((Object)true);
        Mockito.when((Object)this.fragmentRepository.getArtifactsUsingWidget("customLabel")).thenReturn(Collections.singletonList(FragmentBuilder.aFragment().withName("person").build()));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/widgets/customLabel", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isConflict()).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"The widget cannot be deleted because it is used in 1 fragment, <person>"));
    }
}

