/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.controller.export.properties.FragmentPropertiesBuilder;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class FragmentPropertiesBuilderTest {
    private static final String DESIGNER_VERSION = "1.12.1";
    @InjectMocks
    private FragmentPropertiesBuilder fragmentPropertiesBuilder;
    private Fragment fragment;

    @Before
    public void setUp() throws Exception {
        this.fragment = new Fragment();
        this.fragment.setName("myFragment");
    }

    @Test
    public void should_build_a_well_formed_page_property_file() throws Exception {
        this.fragment.setDesignerVersion(DESIGNER_VERSION);
        ReflectionTestUtils.setField((Object)this.fragmentPropertiesBuilder, (String)"uidVersion", (Object)DESIGNER_VERSION);
        byte[] a = this.fragmentPropertiesBuilder.build(this.fragment);
        String properties = new String(a);
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"contentType=fragment"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"name=myFragment"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"designerVersion=1.12.1"});
    }
}

