/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.controller.importer.ArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ImporterResolver;
import org.bonitasoft.web.designer.controller.importer.dependencies.DependencyImporter;
import org.bonitasoft.web.designer.controller.importer.exception.ImportExceptionMatcher;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.Loader;
import org.bonitasoft.web.designer.repository.Repository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.service.AbstractArtifactService;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;

public class ImporterResolverTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Mock
    private PageService pageService;
    private ImporterResolver importerResolver;
    private ArtifactImporter<Page> pageArtifactImporter;
    private ArtifactImporter<Widget> widgetArtifactImporter;
    private ArtifactImporter<Fragment> fragmentArtifactImporter;

    @Before
    public void setUp() throws Exception {
        this.pageArtifactImporter = new ArtifactImporter((Repository)Mockito.mock(Repository.class), (AbstractArtifactService)this.pageService, (Loader)Mockito.mock(Loader.class), new DependencyImporter[0]);
        this.widgetArtifactImporter = new ArtifactImporter((Repository)Mockito.mock(Repository.class), null, (Loader)Mockito.mock(Loader.class), new DependencyImporter[0]);
        this.fragmentArtifactImporter = new ArtifactImporter((Repository)Mockito.mock(Repository.class), null, (Loader)Mockito.mock(Loader.class), new DependencyImporter[0]);
        this.importerResolver = new ImporterResolver(new DesignerConfig().artifactImporters(this.pageArtifactImporter, this.widgetArtifactImporter, this.fragmentArtifactImporter));
    }

    @Test
    public void should_get_page_importer_from_artifact_type() throws Exception {
        ArtifactImporter importer = this.importerResolver.getImporter("page");
        Assertions.assertThat((Object)importer).isEqualTo(this.pageArtifactImporter);
    }

    @Test
    public void should_get_widget_importer_from_artifact_type() throws Exception {
        ArtifactImporter importer = this.importerResolver.getImporter("widget");
        Assertions.assertThat((Object)importer).isEqualTo(this.widgetArtifactImporter);
    }

    @Test(expected=NotFoundException.class)
    public void should_throw_NotFoundException_for_an_unknown_artifact_type() throws Exception {
        this.importerResolver.getImporter("unknown");
    }

    @Test
    public void should_get_page_importer_from_path() throws Exception {
        Path resources = this.tempDir.newFolderPath("resources");
        Files.createFile(resources.resolve("page.json"), new FileAttribute[0]);
        ArtifactImporter importer = this.importerResolver.getImporter(this.tempDir.toPath());
        Assertions.assertThat((Object)importer).isEqualTo(this.pageArtifactImporter);
    }

    @Test
    public void should_get_widget_importer_from_path() throws Exception {
        Path resources = this.tempDir.newFolderPath("resources");
        Files.createFile(resources.resolve("widget.json"), new FileAttribute[0]);
        ArtifactImporter importer = this.importerResolver.getImporter(this.tempDir.toPath());
        Assertions.assertThat((Object)importer).isEqualTo(this.widgetArtifactImporter);
    }

    @Test
    public void should_get_fragment_importer_from_artifact_type() throws Exception {
        ArtifactImporter importer = this.importerResolver.getImporter("fragment");
        Assertions.assertThat((Object)importer).isEqualTo(this.fragmentArtifactImporter);
    }

    @Test
    public void should_get_fragment_importer_from_path() throws Exception {
        Path resources = this.tempDir.newFolderPath("resources");
        Files.createFile(resources.resolve("fragment.json"), new FileAttribute[0]);
        ArtifactImporter importer = this.importerResolver.getImporter(this.tempDir.toPath());
        Assertions.assertThat((Object)importer).isEqualTo(this.fragmentArtifactImporter);
    }

    @Test
    public void should_get_ImportException_while_resources_folder_is_absent() throws Exception {
        this.exception.expect(ImportException.class);
        this.exception.expect((Matcher)ImportExceptionMatcher.hasType(ImportException.Type.UNEXPECTED_ZIP_STRUCTURE));
        this.exception.expectMessage("Incorrect zip structure resources folder is needed");
        this.importerResolver.getImporter(this.tempDir.toPath());
    }

    @Test
    public void should_get_ImportException_while_no_importer_found_from_path() throws Exception {
        this.tempDir.newFolderPath("resources");
        try {
            this.importerResolver.getImporter(this.tempDir.toPath());
            Assertions.failBecauseExceptionWasNotThrown(ImportException.class);
        }
        catch (ImportException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Could not load component, artifact model file not found");
            Assertions.assertThat((Comparable)e.getType()).isEqualTo((Object)ImportException.Type.MODEL_NOT_FOUND);
            Assertions.assertThat((Iterable)((Collection)e.getInfos().get("modelfiles"))).containsOnly((Object[])new String[]{"page.json", "widget.json", "fragment.json"});
        }
    }
}

