/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.dependencies;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetImporter;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.AssetRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AssetImporterTest {
    @Mock
    AssetRepository<Page> pageAssetRepository;
    @InjectMocks
    AssetImporter<Page> pageAssetImporter;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Path zipBaseDir;

    @Before
    public void init() {
        this.zipBaseDir = Paths.get(this.temporaryFolder.getRoot().getPath(), new String[0]);
    }

    public void createDirectoryAsset(String assetType) throws IOException {
        this.temporaryFolder.newFolder("assets");
        this.temporaryFolder.newFolder(new String[]{"assets/", assetType});
    }

    @Test
    public void should_not_thrown_excpetion_when_page_has_no_asset() throws Exception {
        List assets = this.pageAssetImporter.load((Identifiable)PageBuilder.aPage().build(), this.zipBaseDir);
        Assertions.assertThat((List)assets).isEmpty();
    }

    @Test
    public void should_load_assets() throws Exception {
        Page page = PageBuilder.aPage().build();
        this.createDirectoryAsset("css");
        Files.write(this.zipBaseDir.resolve("assets").resolve("css").resolve("myfile.css"), "<style>.maclass1{}</style>".getBytes(), new OpenOption[0]);
        ArrayList<Asset> assetsReturned = new ArrayList<Asset>();
        assetsReturned.add(new Asset().setName("myfile.css"));
        Mockito.when((Object)this.pageAssetRepository.findAssetInPath((Identifiable)page, AssetType.CSS, this.zipBaseDir.resolve("assets").resolve("css"))).thenReturn(assetsReturned);
        List assets = this.pageAssetImporter.load((Identifiable)page, this.zipBaseDir);
        Assertions.assertThat((List)assets).isNotEmpty();
    }
}

