/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.dependencies;

import java.io.File;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.controller.importer.dependencies.WidgetImporter;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WidgetImporterTest {
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private WidgetFileBasedLoader widgetLoader;
    @InjectMocks
    private WidgetImporter widgetImporter;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void should_verify_that_a_widget_exists_in_repository() throws Exception {
        Mockito.when((Object)this.widgetRepository.exists("existingWidget")).thenReturn((Object)true);
        boolean exists = this.widgetImporter.exists((Identifiable)WidgetBuilder.aWidget().id("existingWidget").build());
        Assertions.assertThat((boolean)exists).isTrue();
    }

    @Test
    public void should_verify_that_a_widget_does_not_exists_in_repository() throws Exception {
        Mockito.when((Object)this.widgetRepository.exists("unknownWidget")).thenReturn((Object)false);
        boolean exists = this.widgetImporter.exists((Identifiable)WidgetBuilder.aWidget().id("unknownWidget").build());
        Assertions.assertThat((boolean)exists).isFalse();
    }

    @Test
    public void should_load_custom_widgets() throws Exception {
        File widgetsFolder = this.temporaryFolder.newFolder("widgets");
        this.widgetImporter.load(null, this.temporaryFolder.toPath());
        ((WidgetFileBasedLoader)Mockito.verify((Object)this.widgetLoader)).loadAllCustom(widgetsFolder.toPath());
    }
}

