/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.mocks;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.mockito.Mockito;

public class WidgetImportMock {
    private static final String WIDGETS_FOLDER = "widgets";
    private Path unzippedPath;
    private WidgetFileBasedLoader widgetLoader;
    private WidgetRepository widgetRepository;
    private List<Widget> widgets = new ArrayList<Widget>();

    public WidgetImportMock(Path unzippedPath, WidgetFileBasedLoader widgetLoader, WidgetRepository widgetRepository) throws IOException {
        this.unzippedPath = unzippedPath;
        this.widgetLoader = widgetLoader;
        this.widgetRepository = widgetRepository;
    }

    public List<Widget> mockWidgetsAsAddedDependencies() throws IOException {
        return this.mockWidgetsAsAddedDependencies(WidgetBuilder.aWidget().id("aWidget").custom(), WidgetBuilder.aWidget().id("anotherWidget").custom());
    }

    public List<Widget> mockWidgetsAsAddedDependencies(WidgetBuilder ... widgetBuilders) throws IOException {
        List widgets = Lists.transform(Arrays.asList(widgetBuilders), (Function)new Function<WidgetBuilder, Widget>(){

            public Widget apply(WidgetBuilder builder) {
                return builder.build();
            }
        });
        Files.createDirectories(this.unzippedPath.resolve(WIDGETS_FOLDER), new FileAttribute[0]);
        this.widgets.addAll(widgets);
        Mockito.when((Object)this.widgetRepository.getComponentName()).thenReturn((Object)"widget");
        Mockito.when((Object)this.widgetLoader.loadAllCustom(this.unzippedPath.resolve(WIDGETS_FOLDER))).thenReturn(this.widgets);
        return widgets;
    }

    public List<Widget> mockWidgetsAsOverridenDependencies() throws IOException {
        Files.createDirectories(this.unzippedPath.resolve(WIDGETS_FOLDER), new FileAttribute[0]);
        Widget alreadyThereWidget = WidgetBuilder.aWidget().id("alreadyThereWidget").custom().build();
        Widget anotherExistingWidget = WidgetBuilder.aWidget().id("anotherExistingWidget").custom().build();
        List<Widget> widgets = Arrays.asList(alreadyThereWidget, anotherExistingWidget);
        this.widgets.addAll(widgets);
        Mockito.when((Object)this.widgetRepository.getComponentName()).thenReturn((Object)"widget");
        Mockito.when((Object)this.widgetLoader.loadAllCustom(this.unzippedPath.resolve(WIDGETS_FOLDER))).thenReturn(this.widgets);
        Mockito.when((Object)this.widgetRepository.exists("alreadyThereWidget")).thenReturn((Object)true);
        Mockito.when((Object)this.widgetRepository.exists("anotherExistingWidget")).thenReturn((Object)true);
        Mockito.when((Object)this.widgetRepository.get("alreadyThereWidget")).thenReturn((Object)alreadyThereWidget);
        Mockito.when((Object)this.widgetRepository.get("anotherExistingWidget")).thenReturn((Object)anotherExistingWidget);
        return widgets;
    }
}

