/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping.dataManagement.databind;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.BusinessObject;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.NodeBusinessObjectInput;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.databind.BusinessObjectDeserializer;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BusinessObjectDeserializerTest {
    private ObjectMapper mapper;
    private BusinessObjectDeserializer deserializer;

    @Before
    public void setup() {
        this.mapper = new ObjectMapper();
        this.deserializer = new BusinessObjectDeserializer();
    }

    @Test
    public void deserialize_a_json_complex_businessObject_into_a_businessObject_object() throws Exception {
        String jsonValue = "{  \"name\": \"com.company.bpm.model.Order\",  \"attributes\": [    {      \"name\": \"requester\",      \"type\": \"STRING\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"creationDate\",      \"type\": \"OFFSETDATETIME\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"modifyBy\",      \"type\": \"STRING\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"modificationDate\",      \"type\": \"OFFSETDATETIME\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"category\",      \"type\": \"STRING\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"projectName\",      \"type\": \"STRING\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"projectDescription\",      \"type\": \"TEXT\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"launchDate\",      \"type\": \"LOCALDATE\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"projectCode\",      \"type\": \"STRING\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"process\",      \"type\": \"STRING\",      \"nullable\": \"true\",      \"collection\": \"false\",      \"description\": \"\"    },    {      \"name\": \"comments\",      \"type\": \"AGGREGATION\",      \"nullable\": \"true\",      \"collection\": \"true\",      \"description\": \"\",      \"reference\": \"com.danone.bpm.model.line\",      \"fetchType\": \"LAZY\",      \"attributes\": [        {          \"name\": \"productName\",          \"type\": \"STRING\",          \"nullable\": \"true\",          \"collection\": \"false\",          \"description\": \"\"        },        {          \"name\": \"creationDate\",          \"type\": \"OFFSETDATETIME\",          \"nullable\": \"true\",          \"collection\": \"false\",          \"description\": \"\"        },        {          \"name\": \"comment\",          \"type\": \"TEXT\",          \"nullable\": \"true\",          \"collection\": \"false\",          \"description\": \"\"        },        {          \"name\": \"quantity\",          \"type\": \"INTEGER\",          \"nullable\": \"false\",          \"collection\": \"false\",          \"description\": \"\"        },        {          \"name\": \"price\",          \"type\": \"double\",          \"nullable\": \"false\",          \"collection\": \"false\",          \"description\": \"\"        }      ]    }  ],  \"variableName\": \"order\"}";
        BusinessObject bo = this.deserializer.deserialize(new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(jsonValue), null);
        NodeBusinessObjectInput rootNode = (NodeBusinessObjectInput)bo.getInput().get(0);
        Assert.assertEquals((Object)"order", (Object)rootNode.getPageDataName());
        Assert.assertEquals((long)11L, (long)rootNode.getInput().size());
        Assert.assertEquals((Object)true, (Object)(rootNode.getInput().get(10) instanceof NodeBusinessObjectInput));
        NodeBusinessObjectInput nestedBusinessObject = (NodeBusinessObjectInput)rootNode.getInput().get(10);
        Assert.assertEquals((Object)"order_comments", (Object)nestedBusinessObject.getPageDataName());
        Assert.assertEquals((Object)"comments", (Object)nestedBusinessObject.getBusinessObjectAttributeName());
        Assert.assertEquals((Object)"comments", (Object)nestedBusinessObject.getDataReference().getName());
        Assert.assertEquals((Object)BusinessDataReference.RelationType.AGGREGATION, (Object)nestedBusinessObject.getDataReference().getRelationType());
        Assert.assertEquals((Object)BusinessDataReference.LoadingType.LAZY, (Object)nestedBusinessObject.getDataReference().getLoadingType());
        Assert.assertEquals((Object)rootNode, (Object)nestedBusinessObject.getParent());
    }
}

