/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.i18n.LanguagePackFactory;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.fedorahosted.tennera.jgettext.PoParser;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LanguagePackTest {
    @Rule
    public TemporaryFolder directory = new TemporaryFolder();
    LanguagePackFactory languagePackFactory = new LanguagePackFactory(new PoParser(), new JacksonObjectMapper(new ObjectMapper()));

    @Test
    public void should_convert_translation_into_json() throws Exception {
        File poFile = this.directory.newFile();
        Files.write(poFile.toPath(), this.readResource("/i18n/simple.po"), new OpenOption[0]);
        Assertions.assertThat((String)new String(this.languagePackFactory.create(poFile).toJson())).isEqualTo((Object)"{\"francais\":{\"A page\":\"Une page\"}}");
    }

    @Test
    public void should_convert_plural_translations_into_json() throws Exception {
        File poFile = this.directory.newFile();
        Files.write(poFile.toPath(), this.readResource("/i18n/plural.po"), new OpenOption[0]);
        Assertions.assertThat((String)new String(this.languagePackFactory.create(poFile).toJson())).isEqualTo((Object)"{\"francais\":{\"A page\":[\"Une page\",\"Des pages\"]}}");
    }

    @Test(expected=RuntimeException.class)
    public void should_throw_a_runtime_exception_if_the_po_file_does_not_contains_the_language() throws Exception {
        File poFile = this.directory.newFile();
        Files.write(poFile.toPath(), new String(this.readResource("/i18n/simple.po")).replace("Language: francais", "").getBytes(), new OpenOption[0]);
        Assertions.assertThat((String)new String(this.languagePackFactory.create(poFile).toJson())).isEqualTo((Object)"{\"francais\":{\"A page\":[\"Une page\",\"Des pages\"]}}");
    }

    private byte[] readResource(String path) throws Exception {
        return Files.readAllBytes(Paths.get(this.getClass().getResource(path).toURI()));
    }
}

