/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.page;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PageWithFragmentBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.JsonViewLight;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.exception.ConstraintValidationException;
import org.junit.Before;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class PageTest {
    private ObjectMapper objectMapper;
    private BeanValidator beanValidator;

    @Before
    public void init() {
        this.objectMapper = new DesignerConfig().objectMapper();
        this.beanValidator = new DesignerConfig().beanValidator();
    }

    @Test
    public void jsonview_light_should_only_manage_id_name_hasValidationError_and_favorite() throws Exception {
        String json = this.objectMapper.writerWithView(JsonViewLight.class).writeValueAsString((Object)this.createAFilledPage());
        JSONAssert.assertEquals((String)json, (String)"{\"id\":\"ID\",\"uuid\":\"UUID\",\"name\":\"myPage\",\"type\":\"page\",\"favorite\": true,\"hasValidationError\": false,\"status\": {compatible:true, migration:true}}", (boolean)false);
    }

    @Test
    public void jsonview_persistence_should_manage_all_properties() throws Exception {
        Page myPage = this.createAFilledPage();
        myPage.setFavorite(true);
        Page pageAfterJsonProcessing = (Page)this.objectMapper.readValue(this.objectMapper.writerWithView(JsonViewPersistence.class).writeValueAsString((Object)myPage), Page.class);
        Assertions.assertThat((String)pageAfterJsonProcessing.getName()).isEqualTo((Object)myPage.getName());
        Assertions.assertThat((String)pageAfterJsonProcessing.getId()).isEqualTo((Object)myPage.getId());
        Assertions.assertThat((Map)pageAfterJsonProcessing.getVariables()).isNotEmpty();
        Assertions.assertThat((List)pageAfterJsonProcessing.getRows()).isNotEmpty();
        Assertions.assertThat((boolean)pageAfterJsonProcessing.isFavorite()).isFalse();
        Element element = (Element)((List)pageAfterJsonProcessing.getRows().get(0)).get(0);
        Assertions.assertThat((Map)element.getPropertyValues()).isNotNull();
        Assertions.assertThat((Integer)((Integer)element.getDimension().get("xs"))).isEqualTo(12);
    }

    @Test
    public void jsonview_persistence_page_with_fragment_should_manage_all_properties() throws Exception {
        Page myPage = PageWithFragmentBuilder.aPageWithFragmentElement();
        Page pageAfterJsonProcessing = (Page)this.objectMapper.readValue(this.objectMapper.writerWithView(JsonViewPersistence.class).writeValueAsString((Object)myPage), Page.class);
        Assertions.assertThat((String)pageAfterJsonProcessing.getName()).isEqualTo((Object)myPage.getName());
        Assertions.assertThat((String)pageAfterJsonProcessing.getId()).isEqualTo((Object)myPage.getId());
        Assertions.assertThat((Map)pageAfterJsonProcessing.getVariables()).isNotEmpty();
        Assertions.assertThat((List)pageAfterJsonProcessing.getRows()).isNotEmpty();
        Element element = (Element)((List)pageAfterJsonProcessing.getRows().get(0)).get(0);
        Assertions.assertThat((Map)element.getPropertyValues()).isNotNull();
        Assertions.assertThat((Integer)((Integer)element.getDimension().get("xs"))).isEqualTo(12);
    }

    @Test
    public void jsonview_persitence_should_manage_all_fields() throws Exception {
        Page pageInitial = this.createAFilledPage();
        Page pageAfterJsonProcessing = (Page)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)pageInitial), Page.class);
        Assertions.assertThat((String)pageAfterJsonProcessing.getName()).isNotNull();
        Assertions.assertThat((String)pageAfterJsonProcessing.getId()).isNotNull();
        Assertions.assertThat((Map)pageAfterJsonProcessing.getVariables()).isNotEmpty();
        Assertions.assertThat((List)pageAfterJsonProcessing.getRows()).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((Component)((List)((Container)((List)pageAfterJsonProcessing.getRows().get(0)).get(1)).getRows().get(1)).get(1)).getDescription()).isNotNull()).isNotEmpty();
    }

    @Test
    public void jsonview_persitence_should_persist_component_name_and_description() throws Exception {
        Page pageInitial = PageBuilder.aPage().with(new Element[]{ComponentBuilder.anInput().withDescription("A mandatory name input").build()}).build();
        Page pageAfterJsonProcessing = (Page)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)pageInitial), Page.class);
        Component component = (Component)((List)pageAfterJsonProcessing.getRows().get(0)).get(0);
        ((AbstractStringAssert)Assertions.assertThat((String)component.getDescription()).isNotNull()).isNotEmpty();
    }

    @Test(expected=ConstraintValidationException.class)
    public void should_not_have_a_name_containing_space() throws Exception {
        Page page = PageBuilder.aPage().withName("the name").build();
        this.beanValidator.validate((Object)page);
    }

    @Test(expected=ConstraintValidationException.class)
    public void should_not_have_a_name_containing_special_characters() throws Exception {
        Page page = PageBuilder.aPage().withName("the-name").build();
        this.beanValidator.validate((Object)page);
    }

    @Test
    public void should_check_for_assets_by_type_and_name() throws Exception {
        Page page = PageBuilder.aPage().withAsset(AssetBuilder.anAsset().withType(AssetType.CSS).withName("aName")).build();
        Assertions.assertThat((boolean)page.hasAsset(AssetType.CSS, "aName")).isTrue();
        Assertions.assertThat((boolean)page.hasAsset(AssetType.CSS, "anotherName")).isFalse();
        Assertions.assertThat((boolean)page.hasAsset(AssetType.JAVASCRIPT, "aName")).isFalse();
    }

    private Page createAFilledPage() throws Exception {
        Page page = PageBuilder.aFilledPage("ID");
        page.setUUID("UUID");
        page.setFavorite(true);
        page.setName("myPage");
        page.setStatus(new MigrationStatusReport());
        return page;
    }
}

