/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.widget;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonViewLight;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.utils.ListUtil;
import org.bonitasoft.web.designer.utils.rule.TestResource;
import org.junit.Rule;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class WidgetTest {
    @Rule
    public TestResource testResource = new TestResource(this.getClass());
    private ObjectMapper objectMapper = new DesignerConfig().objectMapper();

    @Test
    public void jsonview_light_should_only_manage_id_name_hasValidationError_and_light_page() throws Exception {
        String json = this.objectMapper.writerWithView(JsonViewLight.class).writeValueAsString((Object)this.createAFilledWidget());
        JSONAssert.assertEquals((String)json, (String)"{\"id\":\"ID2\",\"name\":\"aName\",\"custom\":false,\"favorite\": true,\"status\": {\"compatible\":true, \"migration\":true},\"type\": \"widget\",\"usedBy\":{\"page\":[{\"id\":\"ID\",\"uuid\":\"UUID\",\"name\":\"myPage\",\"type\":\"page\",\"favorite\": false,\"hasValidationError\": false,\"status\": {\"compatible\":true, \"migration\":true}}],\"widget\":[{\"id\":\"ID\",\"name\":\"aName\",\"custom\":false,\"type\": \"widget\",\"favorite\": false,\"status\": {\"compatible\":true, \"migration\":true}}]}}", (boolean)true);
    }

    @Test
    public void jsonview_light_with_fragment_should_only_manage_id_name_hasValidationError_and_light_page() throws Exception {
        String json = this.objectMapper.writerWithView(JsonViewLight.class).writeValueAsString((Object)this.createAFilledWidgetWithFragment());
        JSONAssert.assertEquals((String)json, (String)"{\"id\":\"ID2\",\"name\":\"aName\",\"custom\":false,\"favorite\":false,\"type\":\"widget\",\"status\": {\"compatible\":true, \"migration\":true},\"usedBy\":{\"page\":[{\"id\":\"ID\",\"uuid\":\"UUID\",\"name\":\"myPage\",\"type\":\"page\", \"favorite\":false, \"hasValidationError\": false,\"status\": {\"compatible\":true, \"migration\":true}}],\"fragment\":[{\"id\":\"ID\",\"name\":\"father\",\"type\":\"fragment\", \"favorite\":false, \"hasValidationError\": false,\"status\": {\"compatible\":true, \"migration\":true}}],\"widget\":[{\"id\":\"ID\",\"name\":\"aName\",\"custom\":false,\"favorite\":false, \"type\":\"widget\", \"status\": {\"compatible\":true, \"migration\":true}}]}}", (boolean)true);
    }

    @Test
    public void jsonview_persistence_should_manage_all_fields_except_rows_and_containers() throws Exception {
        Widget widgetInitial = this.createAFilledWidget();
        Widget widgetAfterJsonProcessing = (Widget)this.objectMapper.readValue(this.objectMapper.writerWithView(JsonViewPersistence.class).writeValueAsString((Object)widgetInitial), Widget.class);
        Assertions.assertThat((String)widgetAfterJsonProcessing.getName()).isNotNull();
        Assertions.assertThat((String)widgetAfterJsonProcessing.getDescription()).isEqualTo((Object)"#widget fils d'son p\u00e8re!");
        Assertions.assertThat((String)widgetAfterJsonProcessing.getId()).isNotNull();
        Assertions.assertThat((Map)widgetAfterJsonProcessing.getUsedBy()).isNull();
        Assertions.assertThat((boolean)widgetAfterJsonProcessing.isFavorite()).isFalse();
        Assertions.assertThat((boolean)widgetAfterJsonProcessing.hasHelp()).isFalse();
    }

    @Test
    public void should_convert_widget_id_in_spinal_case() throws Exception {
        String spinalCase = Widget.spinalCase((String)"CUstomDisplayUTCDate");
        Assertions.assertThat((String)spinalCase).isEqualTo((Object)"c-ustom-display-u-t-c-date");
    }

    @Test
    public void should_not_add_useBy_components_when_list_is_empty() throws Exception {
        Widget widget = new Widget();
        widget.addUsedBy("component", new ArrayList());
        Assertions.assertThat((Map)widget.getUsedBy()).isNull();
    }

    @Test
    public void should_not_add_useBy_components_when_list_is_null() throws Exception {
        Widget widget = new Widget();
        widget.addUsedBy("component", null);
        Assertions.assertThat((Map)widget.getUsedBy()).isNull();
    }

    @Test
    public void should_not_add_useBy_components() throws Exception {
        Page page = PageBuilder.aPage().build();
        Widget widget = new Widget();
        widget.addUsedBy("component", ListUtil.asList(new Identifiable[]{page}));
        Assertions.assertThat((List)((List)widget.getUsedBy().get("component"))).containsOnly((Object[])new Identifiable[]{page});
    }

    @Test
    public void should_have_a_default_type_on_desieralization() throws Exception {
        byte[] content = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("widget-with-no-type.json"));
        Widget widget = (Widget)this.objectMapper.readValue(content, Widget.class);
        Assertions.assertThat((String)widget.getType()).isEqualTo((Object)"widget");
    }

    private Widget createAFilledWidget() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("ID").build();
        Widget widgetSon = WidgetBuilder.aWidget().id("ID2").build();
        Page page = PageBuilder.aFilledPage("ID");
        page.setUUID("UUID");
        page.setName("myPage");
        widgetSon.addUsedBy("page", ListUtil.asList(new Identifiable[]{page}));
        widgetSon.addUsedBy("widget", ListUtil.asList(new Identifiable[]{widget}));
        widgetSon.setDescription("#widget fils d'son p\u00e8re!");
        widgetSon.setFavorite(true);
        return widgetSon;
    }

    private Widget createAFilledWidgetWithFragment() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("ID").build();
        Widget widgetSon = WidgetBuilder.aWidget().id("ID2").build();
        Fragment fragment = FragmentBuilder.aFragment().id("ID").withName("father").withHasValidationError(false).build();
        Page page = PageBuilder.aFilledPage("ID");
        page.setUUID("UUID");
        page.setName("myPage");
        page.setHasValidationError(false);
        widgetSon.addUsedBy("page", ListUtil.asList(new Identifiable[]{page}));
        widgetSon.addUsedBy("fragment", ListUtil.asList(new Identifiable[]{fragment}));
        widgetSon.addUsedBy("widget", ListUtil.asList(new Identifiable[]{widget}));
        widgetSon.setDescription("#widget fils d'son p\u00e8re!");
        return widgetSon;
    }
}

