/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.rendering;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.rendering.HtmlGenerator;
import org.bonitasoft.web.designer.visitor.HtmlBuilderVisitor;
import org.jsoup.Jsoup;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class HtmlGeneratorTest {
    @Mock
    private HtmlBuilderVisitor htmlBuilderVisitor;
    @InjectMocks
    private HtmlGenerator generator;

    @Test
    public void should_generate_formatted_html_with_given_widgets() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.htmlBuilderVisitor.build((Previewable)page, "mycontext/")).thenReturn((Object)"foobar");
        String generateHtml = this.generator.generateHtml("mycontext/", (Previewable)page);
        Assertions.assertThat((String)generateHtml).isEqualTo((Object)this.format("foobar"));
    }

    @Test
    public void should_generate_formatted_html_with_no_context() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.htmlBuilderVisitor.build((Previewable)page, "")).thenReturn((Object)"foobar");
        String generateHtml = this.generator.generateHtml((Previewable)page);
        Assertions.assertThat((String)generateHtml).isEqualTo((Object)this.format("foobar"));
    }

    @Test
    public void should_generate_formatted_html_for_fragment_with_given_widgets() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().build();
        Mockito.when((Object)this.htmlBuilderVisitor.build((Previewable)fragment, "mycontext/")).thenReturn((Object)"foobar");
        String generateHtml = this.generator.generateHtml("mycontext/", (Previewable)fragment);
        Assertions.assertThat((String)generateHtml).isEqualTo((Object)this.format("foobar"));
    }

    private String format(String html) {
        return Jsoup.parse((String)html).toString();
    }
}

