/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.studio.repository;

import java.nio.file.Path;
import java.util.Arrays;
import javax.inject.Inject;
import org.bonitasoft.web.designer.ApplicationConfig;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.studio.repository.RepositoryAspect;
import org.bonitasoft.web.designer.studio.workspace.LockedResourceException;
import org.bonitasoft.web.designer.studio.workspace.ResourceNotFoundException;
import org.bonitasoft.web.designer.studio.workspace.WorkspaceResourceHandler;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={ApplicationConfig.class, DesignerConfig.class})
@WebAppConfiguration(value="src/test/resources")
@ActiveProfiles(profiles={"studio"})
public class RepositoryAspectTest {
    @Inject
    @InjectMocks
    private RepositoryAspect repositoryAspect;
    @Inject
    private PageRepository formRepository;
    @Inject
    private WidgetRepository widgetRepository;
    @Mock(name="handler")
    private WorkspaceResourceHandler workspaceResourceHandler;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void should_trigger_postSave_on_workspaceResourceHandler_when_saving_on_formRepository() throws Exception {
        this.formRepository.save((Identifiable)PageBuilder.aPage().withId("aPageId").build());
        ((WorkspaceResourceHandler)Mockito.verify((Object)this.workspaceResourceHandler, (VerificationMode)Mockito.times((int)1))).postSave(this.formRepository.resolvePath("aPageId"));
    }

    @Test
    public void should_trigger_postSave_on_workspaceResourceHandler_when_saving_and_updating_last_update_date_on_formRepository() throws Exception {
        this.formRepository.updateLastUpdateAndSave((Identifiable)PageBuilder.aPage().withId("aPageId").build());
        ((WorkspaceResourceHandler)Mockito.verify((Object)this.workspaceResourceHandler, (VerificationMode)Mockito.times((int)1))).postSave(this.formRepository.resolvePath("aPageId"));
    }

    @Test
    public void should_not_trigger_postSave_on_workspaceResourceHandler_when_saving_several_widgets_in_widgetRepository() throws Exception {
        this.widgetRepository.saveAll(Arrays.asList(WidgetBuilder.aWidget().id("widgetId1").build(), WidgetBuilder.aWidget().id("widgetId2").build()));
        ((WorkspaceResourceHandler)Mockito.verify((Object)this.workspaceResourceHandler, (VerificationMode)Mockito.never())).postSave((Path)Matchers.any(Path.class));
    }

    @Test
    public void should_trigger_delete_on_workspaceResourceHandler_when_deleting_a_widget() throws Exception {
        this.widgetRepository.save((Identifiable)WidgetBuilder.aWidget().id("widgetId1").custom().build());
        this.widgetRepository.delete("widgetId1");
        ((WorkspaceResourceHandler)Mockito.verify((Object)this.workspaceResourceHandler)).delete(this.widgetRepository.resolvePath("widgetId1"));
    }

    @Test
    public void should_trigger_postSave_on_workspaceResourceHandler_when_saving_widget_on_widgetRepository() throws Exception {
        this.widgetRepository.updateLastUpdateAndSave((Identifiable)WidgetBuilder.aWidget().id("widgetId1").build());
        ((WorkspaceResourceHandler)Mockito.verify((Object)this.workspaceResourceHandler)).postSave((Path)Matchers.any(Path.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_an_IllegalArgumentException_when_saving_a_null_reference() throws Exception {
        this.formRepository.updateLastUpdateAndSave((Identifiable)((Page)null));
    }

    @Test(expected=RepositoryException.class)
    public void should_throw_a_RepositoryException_when_saving_if_resource_is_not_found() throws Exception {
        ((WorkspaceResourceHandler)Mockito.doThrow(ResourceNotFoundException.class).when((Object)this.workspaceResourceHandler)).postSave((Path)Matchers.any(Path.class));
        this.formRepository.updateLastUpdateAndSave((Identifiable)PageBuilder.aPage().withId("a_form_id").build());
    }

    @Test
    public void should_NOT_trigger_preOpen_workspaceResourceHandler_when_getting_a_form() throws Exception {
        this.formRepository.save((Identifiable)PageBuilder.aPage().withId("aPageId").build());
        this.formRepository.get("aPageId");
        ((WorkspaceResourceHandler)Mockito.verify((Object)this.workspaceResourceHandler, (VerificationMode)Mockito.never())).preOpen(this.formRepository.resolvePath("aPageId"));
    }

    @Test(expected=IllegalArgumentException.class)
    @Ignore(value="Test ignored until we find a solution for BS-14120")
    public void should_throw_an_IllegalArgumentException_when_getting_a_form_with_a_null_id() throws Exception {
        this.formRepository.get(null);
    }

    @Test(expected=RepositoryException.class)
    @Ignore(value="Test ignored until we find a solution for BS-14120")
    public void should_throw_a_RepositoryException_when_getting_a_missing_resource() throws Exception {
        ((WorkspaceResourceHandler)Mockito.doThrow(ResourceNotFoundException.class).when((Object)this.workspaceResourceHandler)).preOpen((Path)Matchers.any(Path.class));
        this.formRepository.get("a_form_id");
    }

    @Test(expected=RepositoryException.class)
    @Ignore(value="Test ignored until we find a solution for BS-14120")
    public void should_throw_a_RepositoryException_when_getting_a_locked_resource() throws Exception {
        ((WorkspaceResourceHandler)Mockito.doThrow(LockedResourceException.class).when((Object)this.workspaceResourceHandler)).preOpen((Path)Matchers.any(Path.class));
        this.formRepository.get("a_form_id");
    }

    @Test
    public void should_trigger_delete_on_workspaceResourceHandler_when_deleting_a_form() throws Exception {
        this.formRepository.save((Identifiable)PageBuilder.aPage().withId("aPageId").build());
        this.formRepository.delete("aPageId");
        ((WorkspaceResourceHandler)Mockito.verify((Object)this.workspaceResourceHandler)).delete(this.formRepository.resolvePath("aPageId"));
    }

    @Test
    public void should_trigger_postDelete_on_workspaceResourceHandler_when_deleting_a_form() throws Exception {
        this.formRepository.save((Identifiable)PageBuilder.aPage().withId("aPageId").build());
        this.formRepository.delete("aPageId");
        ((WorkspaceResourceHandler)Mockito.verify((Object)this.workspaceResourceHandler)).postDelete(this.formRepository.resolvePath("aPageId"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_an_IllegalArgumentException_when_deleting_a_form_with_a_null_id() throws Exception {
        this.formRepository.delete(null);
    }

    @Test(expected=RepositoryException.class)
    public void should_throw_a_RepositoryException_when_deleting_a_missing_resource() throws Exception {
        ((WorkspaceResourceHandler)Mockito.doThrow(ResourceNotFoundException.class).when((Object)this.workspaceResourceHandler)).postDelete((Path)Matchers.any(Path.class));
        this.formRepository.delete("a_form_id");
    }
}

