/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.visitor.AssetVisitor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AssetVisitorTest {
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private AssetVisitor assetVisitor;

    @Test
    public void should_return_empty_set_when_components_use_no_asset() throws Exception {
        Component component = this.mockComponentFor(WidgetBuilder.aWidget(), null);
        Page page = PageBuilder.aPage().with(new Element[]{component}).build();
        Set assets = this.assetVisitor.visit((Previewable)page);
        Assertions.assertThat((Iterable)assets).isEmpty();
    }

    @Test
    public void should_return_list_of_asset_used_by_widgets() throws Exception {
        Component component = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT), AssetBuilder.anAsset().withName("http://mycdn.com/myfile.js").withType(AssetType.JAVASCRIPT));
        Page page = PageBuilder.aPage().with(new Element[]{component}).build();
        Set assets = this.assetVisitor.visit((Previewable)page);
        Assertions.assertThat((Iterable)assets).extracting("name").containsOnlyOnce(new Object[]{"myfile.js", "http://mycdn.com/myfile.js"});
    }

    @Test
    public void should_return_list_of_asset_used_by_one_page() throws Exception {
        Page page = PageBuilder.aPage().withAsset(AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT).build()).build();
        Set assets = this.assetVisitor.visit((Previewable)page);
        Assertions.assertThat((Iterable)assets).extracting("name").containsOnlyOnce(new Object[]{"myfile.js"});
    }

    @Test
    public void should_return_list_of_distinct_asset_used_by_page_and_widgets() throws Exception {
        Component component = this.mockComponentFor(WidgetBuilder.aWidget(), "id1", AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT), AssetBuilder.anAsset().withName("http://mycdn.com/myfile.js").withType(AssetType.JAVASCRIPT));
        Page page = PageBuilder.aPage().with(new Element[]{component}).withAsset(AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT).build()).build();
        Set assets = this.assetVisitor.visit((Previewable)page);
        Assertions.assertThat((Iterable)assets).extracting("name").contains(new Object[]{"myfile.js", "myfile.js", "http://mycdn.com/myfile.js"});
        Assertions.assertThat((Iterable)assets).extracting("componentId").contains(new Object[]{null, "id1", "id1"});
    }

    @Test
    public void should_return_list_of_asset_needed_by_widgets_in_container() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget(), "id1", AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget(), "id2", AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set assets = this.assetVisitor.visit(ContainerBuilder.aContainer().with(new Element[]{component1, component2}).build());
        Assertions.assertThat((Iterable)assets).extracting("name").containsExactly(new Object[]{"myfile.js", "myfile.js"});
        Assertions.assertThat((Iterable)assets).extracting("componentId").contains(new Object[]{"id2", "id1"});
    }

    @Test
    public void should_return_list_of_asset_needed_by_widgets_in_container_who_have_an_asset() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget(), "id1", AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget(), "id2", AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().assets(AssetBuilder.anAsset().withName("container.min.js").withType(AssetType.JAVASCRIPT)).build());
        Set assets = this.assetVisitor.visit(ContainerBuilder.aContainer().with(new Element[]{component1, component2}).build());
        Assertions.assertThat((Iterable)assets).extracting("name").containsExactly(new Object[]{"container.min.js", "myfile.js", "myfile.js"});
        Assertions.assertThat((Iterable)assets).extracting("componentId").contains(new Object[]{"id2", "id1"});
    }

    @Test
    public void should_return_list_of_asset_needed_by_widgets_in_formcontainer() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.css").withType(AssetType.CSS));
        Mockito.when((Object)this.widgetRepository.get("pbFormContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set assets = this.assetVisitor.visit(FormContainerBuilder.aFormContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1, component2})).build());
        Assertions.assertThat((Iterable)assets).extracting("name").containsOnly(new Object[]{"myfile.js", "myfile.css"});
    }

    public void should_return_list_of_asset_needed_by_widgets_in_formcontainer_who_have_an_asset() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.css").withType(AssetType.CSS));
        Mockito.when((Object)this.widgetRepository.get("pbFormContainer")).thenReturn((Object)WidgetBuilder.aWidget().assets(AssetBuilder.anAsset().withName("formContainer.min.js").withType(AssetType.JAVASCRIPT)).build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set assets = this.assetVisitor.visit(FormContainerBuilder.aFormContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1, component2})).build());
        Assertions.assertThat((Iterable)assets).extracting("name").containsOnly(new Object[]{"myfile.js", "myfile.css", "formContainer.min.js"});
    }

    @Test
    public void should_return_list_of_asset_needed_by_widgets_in_tabscontainer_plus_uibootstrap_which_is_needed_by_tabscontainer() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.css").withType(AssetType.CSS));
        Mockito.when((Object)this.widgetRepository.get("pbTabsContainer")).thenReturn((Object)WidgetBuilder.aWidget().assets(AssetBuilder.anAsset().withName("bootstrap.min.js").withType(AssetType.JAVASCRIPT)).build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set assets = this.assetVisitor.visit(TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().withId("Tab 1").with(ContainerBuilder.aContainer().with(new Element[]{component1})), TabContainerBuilder.aTabContainer().withId("Tab 2").with(ContainerBuilder.aContainer().with(new Element[]{component2}))).build());
        Assertions.assertThat((Iterable)assets).extracting("name").containsOnly(new Object[]{"myfile.js", "myfile.css", "bootstrap.min.js"});
        Assertions.assertThat((String)((Asset)assets.iterator().next()).getComponentId()).isNotEmpty();
    }

    @Test
    public void should_update_inactive_indicator_when_asset_is_inactive_in_a_page() throws Exception {
        Page page = PageBuilder.aPage().withAsset(AssetBuilder.anAsset().withId("assetUIID1").withName("myfile.js").withType(AssetType.JAVASCRIPT).build(), AssetBuilder.anAsset().withId("assetUIID2").withName("myfile.css").withType(AssetType.CSS).build()).withInactiveAsset("assetUIID2").build();
        Set assets = this.assetVisitor.visit((Previewable)page);
        Assertions.assertThat((Iterable)assets).extracting("name").contains(new Object[]{"myfile.js", "myfile.css"});
        Assertions.assertThat((Iterable)assets).extracting("active").contains(new Object[]{true, false});
    }

    @Test
    public void should_return_list_of_asset_needed_by_widgets_in_modal_container() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget(), UUID.randomUUID().toString(), AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Mockito.when((Object)this.widgetRepository.get("pbModalContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set assets = this.assetVisitor.visit(ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1, component2})).build());
        Assertions.assertThat((Iterable)assets).extracting("name").containsExactly(new Object[]{"myfile.js", "myfile.js"});
    }

    @Test
    public void should_good_list_widget_asset__if_one_is_inactive() throws Exception {
        Component component = this.mockComponentFor(WidgetBuilder.aWidget(), "id1", AssetBuilder.anAsset().withName("myfileBis.js").withType(AssetType.JAVASCRIPT), AssetBuilder.anAsset().withName("http://mycdn.com/myfile.js").withType(AssetType.JAVASCRIPT));
        Page page = PageBuilder.aPage().with(new Element[]{component}).withAsset(AssetBuilder.anAsset().withId("assetUIID1").withName("myfile.js").withType(AssetType.JAVASCRIPT).build(), AssetBuilder.anAsset().withId("assetUIID2").withName("myfile.css").withType(AssetType.CSS).build()).withInactiveAsset("assetUIID2", "myfileBis.js").build();
        Set assets = this.assetVisitor.visit((Previewable)page);
        Assertions.assertThat((Iterable)assets).extracting("name").contains(new Object[]{"myfile.js", "myfile.css", "myfileBis.js", "http://mycdn.com/myfile.js"});
        Assertions.assertThat((Iterable)assets).extracting("active").contains(new Object[]{true, false, true, false});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_fragment() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget(), AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget(), AssetBuilder.anAsset().withName("myfile.js").withType(AssetType.JAVASCRIPT));
        FragmentElement fragmentElement = FragmentElementBuilder.aFragmentElement().withFragmentId("my-fragment").build();
        Fragment fragment = FragmentBuilder.aFragment().id("my-fragment").with(new Element[]{component1, component2}).build();
        Mockito.when((Object)this.fragmentRepository.get(fragmentElement.getId())).thenReturn((Object)fragment);
        Set assets = this.assetVisitor.visit((Previewable)fragment);
        Assertions.assertThat((Iterable)assets).extracting("name").containsOnly(new Object[]{"myfile.js"});
    }

    private Component mockComponentFor(WidgetBuilder widgetBuilder, String id, AssetBuilder ... assetBuilders) throws Exception {
        Widget widget = widgetBuilder.id(id).assets(assetBuilders).build();
        Component component = ComponentBuilder.aComponent().withWidgetId(widget.getId()).build();
        Mockito.when((Object)this.widgetRepository.get(component.getId())).thenReturn((Object)widget);
        return component;
    }

    private Component mockComponentFor(WidgetBuilder widgetBuilder, AssetBuilder ... assetBuilders) throws Exception {
        Widget widget = widgetBuilder.id(UUID.randomUUID().toString()).assets(assetBuilders).build();
        Component component = ComponentBuilder.aComponent().withWidgetId(widget.getId()).build();
        Mockito.when((Object)this.widgetRepository.get(component.getId())).thenReturn((Object)widget);
        return component;
    }
}

