/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.RowBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.rendering.GenerationException;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.utils.rule.TestResource;
import org.bonitasoft.web.designer.visitor.PropertyValuesVisitor;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PropertyValuesVisitorTest {
    @Rule
    public TestResource testResource = new TestResource(this.getClass());
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private PropertyValuesVisitor propertyValuesVisitor;
    private PropertyValue propertyValue;

    @Before
    public void setUp() throws Exception {
        this.propertyValue = new PropertyValue();
        this.propertyValue.setType("bar");
        this.propertyValue.setValue((Object)"baz");
    }

    @Test
    public void should_associate_component_paramFeter_values_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((Component)ComponentBuilder.aComponent().withReference("component-id").withPropertyValue("foo", "bar", "baz").build())).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"component-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_associate_container_property_values_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((Container)ContainerBuilder.aContainer().withReference("container-id").withPropertyValue("foo", "bar", "baz").build())).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"container-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_associate_component_property_values_contained_in_a_container_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((Container)ContainerBuilder.aContainer().with(ComponentBuilder.aComponent().withReference("component-id").withPropertyValue("foo", "bar", "baz")).withReference("container-id").build())).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"container-id", Collections.emptyMap()), MapEntry.entry((Object)"component-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_associate_component_parameter_values_contained_in_a_formcontainer_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((FormContainer)FormContainerBuilder.aFormContainer().with((Container)ContainerBuilder.aContainer().with(ComponentBuilder.aComponent().withReference("component-id").withPropertyValue("foo", "bar", "baz")).withReference("container-id").build()).withReference("formcontainer-id").build())).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"formcontainer-id", Collections.emptyMap()), MapEntry.entry((Object)"container-id", Collections.emptyMap()), MapEntry.entry((Object)"component-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_associate_formcontainer_parameter_values_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((FormContainer)FormContainerBuilder.aFormContainer().with((Container)ContainerBuilder.aContainer().withReference("container-id").build()).withReference("formcontainer-id").withPropertyValue("foo", "bar", "baz").build())).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"formcontainer-id", Collections.singletonMap("foo", this.propertyValue)), MapEntry.entry((Object)"container-id", Collections.emptyMap())});
    }

    @Test
    public void should_associate_tabs_container_property_values_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((TabsContainer)TabsContainerBuilder.aTabsContainer().withReference("tabs-container-id").withPropertyValue("foo", "bar", "baz").build())).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"tabs-container-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_associate_component_property_values_contained_in_a_tab_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((TabsContainer)TabsContainerBuilder.aTabsContainer().with((TabContainer)TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(ComponentBuilder.aComponent().withReference("component-id").withPropertyValue("foo", "bar", "baz")).withReference("container-id")).withReference("tab-id").build()).withReference("tabs-container-id").build())).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"tabs-container-id", Collections.emptyMap()), MapEntry.entry((Object)"tab-id", Collections.emptyMap()), MapEntry.entry((Object)"container-id", Collections.emptyMap()), MapEntry.entry((Object)"component-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_associate_component_property_values_contained_in_a_previewable_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((Previewable)PageBuilder.aPage().with(ComponentBuilder.aComponent().withReference("component-id").withPropertyValue("foo", "bar", "baz")).build())).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"component-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_generate_a_service_containing_parameter_values() throws Exception {
        Component component = (Component)ComponentBuilder.aComponent().withPropertyValue("foo", "bar", "baz").withReference("component-ref").build();
        Page page = PageBuilder.aPage().with(new Element[]{component}).build();
        String service = this.propertyValuesVisitor.generate((Previewable)page);
        Assertions.assertThat((String)service).isEqualTo((Object)this.testResource.load("property-value-visitor.result.js"));
    }

    @Test
    public void should_associate_component_property_values_contained_in_a_modal_container_with_its_id() throws Exception {
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit(ModalContainerBuilder.aModalContainer().with((Container)ContainerBuilder.aContainer().with(ComponentBuilder.aComponent().withReference("component-id").withPropertyValue("foo", "bar", "baz")).withReference("container-id").build()).build())).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"modalContainer-reference", Collections.emptyMap()), MapEntry.entry((Object)"container-id", Collections.emptyMap()), MapEntry.entry((Object)"component-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_associate_fragment_property_values_with_its_id() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenReturn((Object)FragmentBuilder.aFragment().build());
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((FragmentElement)FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").withReference("fragment-element-id").withPropertyValue("foo", "bar", "baz").build())).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"fragment-element-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test
    public void should_associate_component_property_values_contained_in_a_fragment_with_its_id() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenReturn((Object)FragmentBuilder.aFragment().with(RowBuilder.aRow().with(ComponentBuilder.aComponent().withReference("component-id").withPropertyValue("foo", "bar", "baz"))).build());
        Assertions.assertThat((Map)this.propertyValuesVisitor.visit((FragmentElement)FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").withReference("fragment-element-id").build())).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"fragment-element-id", Collections.emptyMap()), MapEntry.entry((Object)"component-id", Collections.singletonMap("foo", this.propertyValue))});
    }

    @Test(expected=GenerationException.class)
    public void should_throw_a_generation_error_when_fragment_is_not_found() {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenThrow(new Throwable[]{new NotFoundException("")});
        this.propertyValuesVisitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").build());
    }

    @Test(expected=GenerationException.class)
    public void should_throw_a_generation_error_when_there_is_a_repository_error_while_looking_for_a_fragment() {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenThrow(new Throwable[]{new RepositoryException("", (Throwable)new RuntimeException())});
        this.propertyValuesVisitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").build());
    }
}

