/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.visitor.WidgetIdVisitor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WidgetIdVisitorTest {
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private WidgetIdVisitor visitor;

    @Test
    public void should_add_widgetId_of_component() {
        Component component = this.createComponentWithWidget("foo");
        Assertions.assertThat((Iterable)this.visitor.visit(component)).containsExactly((Object[])new String[]{"foo"});
    }

    @Test
    public void should_traverse_container() {
        Container container = new Container();
        List<Element> row1 = Arrays.asList(this.createComponentWithWidget("foo"));
        List<Element> row2 = Arrays.asList(this.createComponentWithWidget("bar"));
        container.setRows(Arrays.asList(row1, row2));
        Assertions.assertThat((Iterable)this.visitor.visit(container)).containsOnly((Object[])new String[]{"foo", "bar", "pbContainer"});
    }

    @Test
    public void should_traverse_formcontainer() {
        FormContainer formContainer = new FormContainer();
        Container container = new Container();
        List<Element> row1 = Arrays.asList(this.createComponentWithWidget("foo"));
        List<Element> row2 = Arrays.asList(this.createComponentWithWidget("bar"));
        container.setRows(Arrays.asList(row1, row2));
        formContainer.setContainer(container);
        Assertions.assertThat((Iterable)this.visitor.visit(formContainer)).containsOnly((Object[])new String[]{"foo", "bar", "pbContainer", "pbFormContainer"});
    }

    @Test
    public void should_traverse_tabs_container() {
        TabsContainer tabsContainer = new TabsContainer();
        Container container1 = new Container();
        List<Element> row1 = Arrays.asList(this.createComponentWithWidget("foo"));
        container1.setRows(Arrays.asList(row1));
        TabContainer tabContainer1 = new TabContainer();
        tabContainer1.setContainer(container1);
        tabsContainer.setTabList(Arrays.asList(tabContainer1));
        Assertions.assertThat((Iterable)this.visitor.visit(tabsContainer)).containsExactly((Object[])new String[]{"pbTabsContainer", "pbContainer", "foo", "pbTabContainer"});
    }

    @Test
    public void should_traverse_modal_container() {
        ModalContainer modalContainer = new ModalContainer();
        List<Element> row1 = Arrays.asList(this.createComponentWithWidget("foo"));
        List<Element> row2 = Arrays.asList(this.createComponentWithWidget("bar"));
        modalContainer.getContainer().setRows(Arrays.asList(row1, row2));
        Assertions.assertThat((Iterable)this.visitor.visit(modalContainer)).containsOnly((Object[])new String[]{"pbContainer", "foo", "bar", "pbModalContainer"});
    }

    @Test
    public void should_traverse_fragment_element() {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("fragment1");
        List<Element> row1 = Arrays.asList(this.createComponentWithWidget("foo"));
        Fragment fragment = new Fragment();
        fragment.setRows(Arrays.asList(row1));
        Mockito.when((Object)this.fragmentRepository.get(fragmentElement.getId())).thenReturn((Object)fragment);
        Assertions.assertThat((Iterable)this.visitor.visit(fragmentElement)).containsExactly((Object[])new String[]{"foo"});
    }

    private Component createComponentWithWidget(String widgetId) {
        Component component = new Component();
        component.setId(widgetId);
        return component;
    }
}

