/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetScope;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;

public class AssetBuilder {
    private String id;
    private String name = "myasset.js";
    private AssetType type = AssetType.JAVASCRIPT;
    private String scope;
    private String componentId;
    private Boolean external = false;
    private int order = 1;
    private boolean active = true;

    public static AssetBuilder anAsset() {
        return new AssetBuilder();
    }

    public static Asset aFilledAsset(Page page) {
        return AssetBuilder.anAsset().withScope(AssetScope.PAGE).withComponentId(page.getId()).build();
    }

    public AssetBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public AssetBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public AssetBuilder withOrder(int order) {
        this.order = order;
        return this;
    }

    public AssetBuilder withType(AssetType type) {
        this.type = type;
        return this;
    }

    public AssetBuilder withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public AssetBuilder withComponentId(String id) {
        this.componentId = id;
        return this;
    }

    public AssetBuilder withExternal(boolean external) {
        this.external = external;
        return this;
    }

    public AssetBuilder active() {
        this.active = true;
        return this;
    }

    public AssetBuilder unactive() {
        this.active = false;
        return this;
    }

    public Asset build() {
        return new Asset().setId(this.id).setName(this.name).setType(this.type).setScope(this.scope).setOrder(this.order).setComponentId(this.componentId).setActive(this.active).setExternal(this.external.booleanValue());
    }
}

