/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ResponsiveDimension;
import org.bonitasoft.web.designer.builder.RowBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;

public class FragmentBuilder {
    private String id = UUID.randomUUID().toString();
    private String name = "fragment";
    private String designerVersion;
    private String modelVersion;
    private String previousArtifactVersion;
    private String previousDesignerVersion;
    private Map<String, Variable> variables = new HashMap<String, Variable>();
    private List<List<Element>> rows = new ArrayList<List<Element>>();
    private Set<Asset> assets = new HashSet<Asset>();
    private boolean favorite = false;
    private boolean hasValidationError = false;
    private MigrationStatusReport migrationStatusReport = new MigrationStatusReport();

    public static FragmentBuilder aFragment() {
        return new FragmentBuilder();
    }

    public FragmentBuilder id(String id) {
        this.id = id;
        return this;
    }

    public FragmentBuilder with(RowBuilder row) {
        this.rows.add(row.build());
        return this;
    }

    public FragmentBuilder with(Element ... elements) {
        this.rows.add(Arrays.asList(elements));
        return this;
    }

    public FragmentBuilder with(ElementBuilder ... elements) {
        for (ElementBuilder element : elements) {
            this.rows.add(Arrays.asList(element.build()));
        }
        return this;
    }

    public FragmentBuilder with(AssetBuilder ... assets) {
        for (AssetBuilder asset : assets) {
            this.assets.add(asset.build());
        }
        return this;
    }

    public FragmentBuilder with(Asset ... assets) {
        for (Asset asset : assets) {
            this.assets.add(asset);
        }
        return this;
    }

    public FragmentBuilder with(Fragment fragment) {
        return this.with(FragmentElementBuilder.aFragmentElement().withFragmentId(fragment.getId()));
    }

    public FragmentBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public FragmentBuilder withDesignerVersion(String version) {
        this.designerVersion = version;
        return this;
    }

    public FragmentBuilder withModelVersion(String version) {
        this.modelVersion = version;
        return this;
    }

    public FragmentBuilder withPreviousArtifactVersion(String previousArtifactVersion) {
        this.previousArtifactVersion = previousArtifactVersion;
        return this;
    }

    public FragmentBuilder withPreviousDesignerVersion(String previousDesignerVersion) {
        this.previousDesignerVersion = previousDesignerVersion;
        return this;
    }

    public FragmentBuilder favorite() {
        this.favorite = true;
        return this;
    }

    public FragmentBuilder notFavorite() {
        this.favorite = false;
        return this;
    }

    public FragmentBuilder withMigrationStatusReport(MigrationStatusReport migrationStatusReport) {
        this.migrationStatusReport = migrationStatusReport;
        return this;
    }

    public FragmentBuilder isCompatible(boolean compatible) {
        this.migrationStatusReport.setCompatible(compatible);
        return this;
    }

    public FragmentBuilder isMigration(boolean migration) {
        this.migrationStatusReport.setMigration(migration);
        return this;
    }

    public FragmentBuilder withHasValidationError(boolean hasValidationError) {
        this.hasValidationError = hasValidationError;
        return this;
    }

    public Fragment build() {
        Fragment fragment = new Fragment();
        fragment.setId(this.id);
        fragment.setName(this.name);
        fragment.setVariables(this.variables);
        fragment.setRows(this.rows);
        fragment.setAssets(this.assets);
        fragment.setFavorite(this.favorite);
        fragment.setDesignerVersion(this.designerVersion);
        fragment.setModelVersion(this.modelVersion);
        if (this.previousArtifactVersion != null) {
            fragment.setPreviousArtifactVersion(this.previousArtifactVersion);
        } else {
            fragment.setPreviousDesignerVersion(this.previousDesignerVersion);
        }
        fragment.setStatus(this.migrationStatusReport);
        fragment.setHasValidationError(this.hasValidationError);
        return fragment;
    }

    public FragmentBuilder withVariable(String name, Variable variable) {
        this.variables.put(name, variable);
        return this;
    }

    public FragmentBuilder withVariable(String name, VariableBuilder variableBuilder) {
        return this.withVariable(name, variableBuilder.build());
    }

    public static Fragment aFilledFragment(String id) throws Exception {
        RowBuilder row = RowBuilder.aRow().with(ComponentBuilder.aParagraph().withPropertyValue("content", "hello <br/> world").withDimensions(ResponsiveDimension.md(6)), ComponentBuilder.anInput().withPropertyValue("required", false).withPropertyValue("placeholder", "enter you're name").withDimensions(ResponsiveDimension.md(6)));
        Container containerWithTwoRows = ContainerBuilder.aContainer().with(row, row).build();
        TabContainer tabContainer = new TabContainer();
        tabContainer.setContainer(containerWithTwoRows);
        TabContainer tabContainer2 = new TabContainer();
        tabContainer2.setContainer(containerWithTwoRows);
        TabsContainer tabsContainer = new TabsContainer();
        tabsContainer.setTabList(Arrays.asList(tabContainer, tabContainer2));
        FragmentElement fragment = new FragmentElement();
        fragment.setId("a-fragment");
        fragment.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Container fragmentContainer = ContainerBuilder.aContainer().with(new Element[]{fragment}).build();
        return FragmentBuilder.aFragment().id(id).with(new Element[]{tabsContainer, containerWithTwoRows, fragmentContainer}).withVariable("aVariable", VariableBuilder.aConstantVariable().value("a value")).withVariable("anotherVariable", VariableBuilder.aConstantVariable().value("4")).build();
    }
}

