/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import com.fasterxml.jackson.core.FakeJsonProcessingException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Sets;
import com.jayway.jsonassert.impl.matcher.IsCollectionWithSize;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PageWithFragmentBuilder;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.controller.PageResource;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.controller.asset.MalformedJsonException;
import org.bonitasoft.web.designer.generator.mapping.ContractToPageMapper;
import org.bonitasoft.web.designer.generator.mapping.FormScope;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ParameterType;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetScope;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.contract.Contract;
import org.bonitasoft.web.designer.model.contract.builders.ContractBuilder;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.utils.RestControllerUtil;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.bonitasoft.web.designer.visitor.AssetVisitor;
import org.bonitasoft.web.designer.visitor.AuthRulesCollector;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.http.MediaType;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.web.multipart.MultipartFile;

@RunWith(value=MockitoJUnitRunner.class)
public class PageResourceTest {
    private MockMvc mockMvc;
    @Mock
    private PageRepository pageRepository;
    @Mock
    private PageService pageService;
    @Mock
    private SimpMessagingTemplate messagingTemplate;
    @Mock
    private ContractToPageMapper contractToPageMapper;
    @Mock
    private AssetService<Page> pageAssetService;
    @Mock
    private AssetVisitor assetVisitor;
    @InjectMocks
    private PageResource pageResource;
    private Path widgetRepositoryPath;
    private Component startProcessComponent;
    private Component submitTaskComponent;
    private Page page;
    @Mock
    private ComponentVisitor componentVisitor;
    @Mock
    private AuthRulesCollector authRulesCollector;

    @Before
    public void setUp() throws URISyntaxException {
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.pageResource).build();
        this.widgetRepositoryPath = Paths.get(this.getClass().getResource("/workspace/widgets").toURI());
    }

    private Page mockPageOfId(String id) {
        Page page = PageBuilder.aPage().withId(id).build();
        Mockito.when((Object)this.pageRepository.get(id)).thenReturn((Object)page);
        Mockito.when((Object)this.pageService.get(id)).thenReturn((Object)page);
        return page;
    }

    @Test
    public void should_list_pages() throws Exception {
        Page page = new Page();
        page.setId("id");
        page.setName("name");
        page.setLastUpdate(Instant.parse((String)"2015-02-02"));
        Mockito.when((Object)this.pageRepository.getAll()).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].id", (Object[])new Object[0]).value((Object)"id")).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].name", (Object[])new Object[0]).value((Object)"name")).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].lastUpdate", (Object[])new Object[0]).value((Object)Instant.parse((String)"2015-02-02").getMillis()));
    }

    @Test
    public void should_create_a_page_from_a_Page() throws Exception {
        Page pageToBeSaved = PageBuilder.aPage().withId("my-page").build();
        List emptyRow = Collections.emptyList();
        List rows = Collections.singletonList(emptyRow);
        pageToBeSaved.setRows(rows);
        pageToBeSaved.setName("test");
        Mockito.when((Object)this.pageRepository.getNextAvailableId("test")).thenReturn((Object)"test");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/pages", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pageToBeSaved))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)CoreMatchers.notNullValue()));
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)Mockito.notNull(Page.class));
        ((AssetService)Mockito.verify(this.pageAssetService)).loadDefaultAssets((Assetable)Mockito.any(Page.class));
    }

    @Test
    public void should_duplicate_a_page_from_a_Page() throws Exception {
        Asset pageAsset = this.aPageAsset();
        Asset widgetAsset = this.aWidgetAsset();
        Page pageToBeSaved = PageBuilder.aPage().withId("my-page").withName("test").withAsset(pageAsset, widgetAsset).build();
        Mockito.when((Object)this.pageRepository.get("my-page-source")).thenReturn((Object)PageBuilder.aPage().withId("my-page-source").withName("test").withAsset(pageAsset, widgetAsset).build());
        Mockito.when((Object)this.pageRepository.getNextAvailableId("test")).thenReturn((Object)"test");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/pages?duplicata=my-page-source", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pageToBeSaved))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)CoreMatchers.notNullValue()));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Page.class);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)argument.capture());
        Assertions.assertThat((String)((Page)argument.getValue()).getName()).isEqualTo((Object)pageToBeSaved.getName());
        Assertions.assertThat((Iterable)((Page)argument.getValue()).getAssets()).containsOnly((Object[])new Asset[]{pageAsset});
        ((AssetService)Mockito.verify(this.pageAssetService)).duplicateAsset((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.eq((Object)"my-page-source"), Mockito.anyString());
    }

    @Test
    public void should_create_a_page_from_a_Contract_at_task_scope() throws Exception {
        Contract contract = ContractBuilder.aSimpleContract();
        Page newPage = PageBuilder.aPage().withName("myPage").build();
        Mockito.when((Object)this.contractToPageMapper.createFormPage((String)Mockito.eq((Object)"myPage"), (Contract)Mockito.notNull(Contract.class), (FormScope)Mockito.eq((Object)FormScope.TASK))).thenReturn((Object)newPage);
        Mockito.when((Object)this.pageRepository.getNextAvailableId("myPage")).thenReturn((Object)"myPage");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/pages/contract/task/myPage", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(contract))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)CoreMatchers.notNullValue()));
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)newPage);
    }

    @Test
    public void should_create_a_page_from_a_Contract_at_process_scope() throws Exception {
        Contract contract = ContractBuilder.aSimpleContract();
        Page newPage = PageBuilder.aPage().withName("myPage").build();
        Mockito.when((Object)this.contractToPageMapper.createFormPage((String)Mockito.eq((Object)"myPage"), (Contract)Mockito.notNull(Contract.class), (FormScope)Mockito.eq((Object)FormScope.PROCESS))).thenReturn((Object)newPage);
        Mockito.when((Object)this.pageRepository.getNextAvailableId("myPage")).thenReturn((Object)"myPage");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/pages/contract/process/myPage", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(contract))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)CoreMatchers.notNullValue()));
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)newPage);
    }

    @Test
    public void should_create_a_page_from_a_Contract_at_overview_scope() throws Exception {
        Contract contract = ContractBuilder.aSimpleContract();
        Page newPage = PageBuilder.aPage().withName("myPage").build();
        Mockito.when((Object)this.contractToPageMapper.createFormPage((String)Mockito.eq((Object)"myPage"), (Contract)Mockito.notNull(Contract.class), (FormScope)Mockito.eq((Object)FormScope.OVERVIEW))).thenReturn((Object)newPage);
        Mockito.when((Object)this.pageRepository.getNextAvailableId("myPage")).thenReturn((Object)"myPage");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/pages/contract/overview/myPage", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(contract))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)CoreMatchers.notNullValue()));
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)newPage);
    }

    @Test
    public void should_save_a_page() throws Exception {
        Page pageToBeSaved = this.mockPageOfId("my-page");
        ResultActions result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pageToBeSaved))).andExpect(MockMvcResultMatchers.status().isOk());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageToBeSaved);
        ((SimpMessagingTemplate)Mockito.verify((Object)this.messagingTemplate)).convertAndSend((Object)"/previewableUpdates", (Object)"my-page");
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON.toString(), (Object)result.andReturn().getResponse().getContentType());
    }

    @Test
    public void should_save_a_page_with_fragment() throws Exception {
        Page pageToBeSaved = PageWithFragmentBuilder.aPageWithFragmentElement();
        pageToBeSaved.setId(pageToBeSaved.getName());
        Mockito.when((Object)this.pageService.get(pageToBeSaved.getName())).thenThrow(new Throwable[]{new NotFoundException()});
        Mockito.when((Object)this.pageRepository.getNextAvailableId(pageToBeSaved.getName())).thenReturn((Object)pageToBeSaved.getName());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/rest/pages/" + pageToBeSaved.getName()), (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pageToBeSaved))).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageToBeSaved);
        ((SimpMessagingTemplate)Mockito.verify((Object)this.messagingTemplate)).convertAndSend((Object)"/previewableUpdates", (Object)pageToBeSaved.getName());
    }

    @Test
    public void should_save_a_page_renaming_it() throws Exception {
        Page pageToBeUpdated = PageBuilder.aPage().withId("my-page").withName("my-page").build();
        pageToBeUpdated.addAsset(AssetBuilder.aFilledAsset(pageToBeUpdated));
        Mockito.when((Object)this.pageService.get("my-page")).thenReturn((Object)pageToBeUpdated);
        Page pageToBeSaved = PageBuilder.aPage().withName("page-new-name").build();
        pageToBeSaved.addAsset(AssetBuilder.aFilledAsset(pageToBeUpdated));
        Mockito.when((Object)this.pageRepository.getNextAvailableId("page-new-name")).thenReturn((Object)"page-new-name");
        ResultActions result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pageToBeSaved))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/pages/page-new-name"));
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)PageBuilder.aPage().withId("page-new-name").withName("page-new-name").build());
        ((AssetService)Mockito.verify(this.pageAssetService)).duplicateAsset(this.pageRepository.resolvePath("my-page"), this.pageRepository.resolvePath("my-page"), "my-page", "page-new-name");
        ((SimpMessagingTemplate)Mockito.verify((Object)this.messagingTemplate)).convertAndSend((Object)"/previewableRemoval", (Object)"my-page");
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON.toString(), (Object)result.andReturn().getResponse().getContentType());
    }

    @Test
    public void should_not_save_widget_assets_while_saving_a_page() throws Exception {
        Page pageToBeSaved = PageBuilder.aPage().withId("my-page").withAsset(this.aWidgetAsset(), this.aPageAsset()).build();
        Mockito.when((Object)this.pageService.get("my-page")).thenReturn((Object)pageToBeSaved);
        Page expectedPage = PageBuilder.aPage().withId("my-page").withAsset(this.aPageAsset()).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pageToBeSaved))).andExpect(MockMvcResultMatchers.status().isOk());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)expectedPage);
    }

    private Asset aPageAsset() {
        return AssetBuilder.anAsset().withName("myJs.js").withType(AssetType.JAVASCRIPT).build();
    }

    private Asset aWidgetAsset() {
        return AssetBuilder.anAsset().withName("myCss.css").withType(AssetType.CSS).withScope(AssetScope.WIDGET).withComponentId("widget-id").build();
    }

    @Test
    public void should_respond_415_unsupported_media_type_when_trying_to_save_non_json_content() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page", (Object[])new Object[0]).content("this is not json")).andExpect(MockMvcResultMatchers.status().is(415));
    }

    @Test
    public void should_respond_500_internal_error_if_error_occurs_while_saving_a_page() throws Exception {
        Page page = PageBuilder.aPage().withId("my-page").build();
        ((PageRepository)Mockito.doThrow((Throwable)new RepositoryException("exception occurs", (Throwable)new Exception())).when((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(page))).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_retrieve_a_page_representation_by_its_id() throws Exception {
        Page expectedPage = PageBuilder.aFilledPage("my-page");
        expectedPage.setStatus(new MigrationStatusReport(true, true));
        Mockito.when((Object)this.pageService.get("my-page")).thenReturn((Object)expectedPage);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/my-page", (Object[])new Object[0])).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void should_respond_404_not_found_if_page_is_not_existing() throws Exception {
        Mockito.when((Object)this.pageService.get("my-page")).thenThrow(new Throwable[]{new NotFoundException("page not found")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/my-page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_422_on_load_when_page_is_incompatible() throws Exception {
        Page expectedPage = PageBuilder.aFilledPage("my-page");
        expectedPage.setStatus(new MigrationStatusReport(false, true));
        Mockito.when((Object)this.pageService.get("my-page")).thenReturn((Object)expectedPage);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/my-page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(422));
    }

    @Test
    public void should_respond_422_on_save_when_page_is_incompatible() throws Exception {
        Page pageToBeSaved = this.mockPageOfId("my-page");
        pageToBeSaved.setStatus(new MigrationStatusReport(false, true));
        ResultActions result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(pageToBeSaved))).andExpect(MockMvcResultMatchers.status().is(422));
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)pageToBeSaved);
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN.toString(), (Object)result.andReturn().getResponse().getContentType());
    }

    @Test
    public void should_respond_404_not_found_when_delete_inexisting_page() throws Exception {
        ((PageRepository)Mockito.doThrow((Throwable)new NotFoundException("page not found")).when((Object)this.pageRepository)).delete("my-page");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/pages/my-page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_500_internal_error_when_error_on_deletion_page() throws Exception {
        ((PageRepository)Mockito.doThrow((Throwable)new RepositoryException("error occurs", (Throwable)new RuntimeException())).when((Object)this.pageRepository)).delete("my-page");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/pages/my-page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_delete_a_page() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/pages/my-page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void should_rename_a_page() throws Exception {
        String newName = "my-page-new-name";
        Page pageToBeUpdated = PageBuilder.aPage().withId("my-page").withName("page-name").build();
        Mockito.when((Object)this.pageService.get("my-page")).thenReturn((Object)pageToBeUpdated);
        Mockito.when((Object)this.pageRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/name", (Object[])new Object[0]).contentType("application/json").content(newName)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/pages/" + newName));
        ArgumentCaptor pageArgumentCaptor = ArgumentCaptor.forClass(Page.class);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).getNextAvailableId(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageArgumentCaptor.capture());
        Assertions.assertThat((String)((Page)pageArgumentCaptor.getValue()).getName()).isEqualTo((Object)newName);
        Assertions.assertThat((String)((Page)pageArgumentCaptor.getValue()).getId()).isEqualTo((Object)newName);
    }

    @Test
    public void should_not_rename_a_page_if_name_is_same() throws Exception {
        String name = "page-name";
        Page pageToBeUpdated = PageBuilder.aPage().withId("my-page").withName(name).build();
        Mockito.when((Object)this.pageService.get("my-page")).thenReturn((Object)pageToBeUpdated);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/name", (Object[])new Object[0]).contentType("application/json").content(name)).andExpect(MockMvcResultMatchers.status().isOk());
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)Mockito.any(Page.class));
    }

    @Test
    public void should_keep_assets_when_page_is_renamed() throws Exception {
        String newName = "my-page-new-name";
        Page pageToBeUpdated = PageBuilder.aPage().withId("my-page").withName("page-name").build();
        pageToBeUpdated.addAsset(AssetBuilder.aFilledAsset(pageToBeUpdated));
        Mockito.when((Object)this.pageService.get("my-page")).thenReturn((Object)pageToBeUpdated);
        Mockito.when((Object)this.pageRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/name", (Object[])new Object[0]).contentType("application/json").content(newName)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/pages/" + newName));
        ArgumentCaptor pageArgumentCaptor = ArgumentCaptor.forClass(Page.class);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).getNextAvailableId(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageArgumentCaptor.capture());
        ((AssetService)Mockito.verify(this.pageAssetService)).duplicateAsset(this.pageRepository.resolvePath("my-page"), this.pageRepository.resolvePath("my-page"), "my-page", "my-page-new-name");
        Assertions.assertThat((String)((Page)pageArgumentCaptor.getValue()).getName()).isEqualTo((Object)newName);
        Assertions.assertThat((String)((Page)pageArgumentCaptor.getValue()).getId()).isEqualTo((Object)newName);
    }

    @Test
    public void should_respond_404_not_found_if_page_is_not_existing_when_renaming() throws Exception {
        Mockito.when((Object)this.pageService.get("my-page")).thenThrow(new Throwable[]{new NotFoundException("page not found")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/name", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes("hello"))).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_500_internal_error_if_error_occurs_while_renaming_a_page() throws Exception {
        ((PageRepository)Mockito.doThrow((Throwable)new RepositoryException("exception occurs", (Throwable)new Exception())).when((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)Mockito.any(Page.class));
        this.mockPageOfId("my-page");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/name", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes("hello"))).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_upload_a_local_asset() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.js", "application/javascript", "foo".getBytes());
        Page page = this.mockPageOfId("my-page");
        Asset expectedAsset = AssetBuilder.anAsset().withId("assetId").active().withName("myfile.js").withOrder(2).withScope(AssetScope.PAGE).withType(AssetType.JAVASCRIPT).build();
        Mockito.when((Object)this.pageAssetService.upload((MultipartFile)file, (Assetable)page, "js")).thenReturn((Object)expectedAsset);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/rest/pages/my-page/assets/js", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Object[])new Object[0]).value((Object)"assetId")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"myfile.js")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Object[])new Object[0]).value((Object)AssetScope.PAGE.toString())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Object[])new Object[0]).value((Object)"js")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.order", (Object[])new Object[0]).value((Object)2));
        ((AssetService)Mockito.verify(this.pageAssetService)).upload((MultipartFile)file, (Assetable)page, "js");
    }

    @Test
    public void should_respond_202_with_error_when_uploading_a_json_asset_with_malformed_json_file() throws Exception {
        byte[] content = "notvalidjson".getBytes();
        MockMultipartFile file = this.aJsonFileWithContent(content);
        int expectedLine = 4;
        int expectedColumn = 2;
        Mockito.when((Object)this.pageAssetService.upload((MultipartFile)file, (Assetable)this.mockPageOfId("my-page"), "json")).thenThrow(new Throwable[]{this.aMalformedJsonException(content, expectedLine, expectedColumn)});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/rest/pages/my-page/assets/json", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Object[])new Object[0]).value((Object)"MalformedJsonException")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.infos.location.line", (Object[])new Object[0]).value((Object)expectedLine)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.infos.location.column", (Object[])new Object[0]).value((Object)expectedColumn));
    }

    private MockMultipartFile aJsonFileWithContent(byte[] content) {
        return new MockMultipartFile("file", "myfile.js", "application/json", content);
    }

    private MalformedJsonException aMalformedJsonException(byte[] bytes, int errorLine, int errorColumn) {
        return new MalformedJsonException((JsonProcessingException)new FakeJsonProcessingException("Error while checking json", bytes, errorLine, errorColumn));
    }

    @Test
    public void should_not_upload_an_asset_when_upload_send_an_error() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.js", "application/javascript", "foo".getBytes());
        Page page = this.mockPageOfId("my-page");
        ((AssetService)Mockito.doThrow(IllegalArgumentException.class).when(this.pageAssetService)).upload((MultipartFile)file, (Assetable)page, "js");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/rest/pages/my-page/assets/js", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((AssetService)Mockito.verify(this.pageAssetService)).upload((MultipartFile)file, (Assetable)page, "js");
    }

    @Test
    public void should_save_an_external_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset expectedAsset = AssetBuilder.anAsset().withId("assetId").active().withName("myfile.js").withOrder(2).withScope(AssetScope.PAGE).withType(AssetType.JAVASCRIPT).build();
        Mockito.when((Object)this.pageAssetService.save((Assetable)page, expectedAsset)).thenReturn((Object)expectedAsset);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/pages/my-page/assets", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(expectedAsset))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Object[])new Object[0]).value((Object)"assetId")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"myfile.js")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Object[])new Object[0]).value((Object)AssetScope.PAGE.toString())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Object[])new Object[0]).value((Object)"js")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.order", (Object[])new Object[0]).value((Object)2));
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, expectedAsset);
    }

    @Test
    public void should_not_save_an_external_asset_when_upload_send_an_error() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset asset = AssetBuilder.anAsset().build();
        ((AssetService)Mockito.doThrow(IllegalArgumentException.class).when(this.pageAssetService)).save((Assetable)page, asset);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/pages/my-page/assets", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(asset))).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void should_list_page_assets() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Object[] assets = new Asset[]{AssetBuilder.anAsset().withName("myCss.css").withType(AssetType.CSS).withScope(AssetScope.WIDGET).withComponentId("widget-id").build(), AssetBuilder.anAsset().withName("myJs.js").withType(AssetType.JAVASCRIPT).withScope(AssetScope.PAGE).build(), AssetBuilder.anAsset().withName("https://mycdn.com/myExternalJs.js").withScope(AssetScope.PAGE).withType(AssetType.JAVASCRIPT).build()};
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn((Object)Sets.newHashSet((Object[])assets));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/my-page/assets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].name", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"https://mycdn.com/myExternalJs.js", "myJs.js", "myCss.css"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].type", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"js", "js", "css"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].scope", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"page", "page", "widget"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].componentId", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"widget-id"})));
    }

    @Test
    public void should_list_page_assets_while_getting_a_page() throws Exception {
        Page page = this.mockPageOfId("my-page");
        page.setStatus(new MigrationStatusReport(true, true));
        Object[] assets = new Asset[]{AssetBuilder.anAsset().withName("myCss.css").withType(AssetType.CSS).withScope(AssetScope.WIDGET).withComponentId("widget-id").build(), AssetBuilder.anAsset().withName("myJs.js").withType(AssetType.JAVASCRIPT).withScope(AssetScope.PAGE).build(), AssetBuilder.anAsset().withName("https://mycdn.com/myExternalJs.js").withType(AssetType.JAVASCRIPT).withScope(AssetScope.PAGE).build()};
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn((Object)Sets.newHashSet((Object[])assets));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/my-page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.assets", (Matcher)IsCollectionWithSize.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.assets[*].name", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"https://mycdn.com/myExternalJs.js", "myJs.js", "myCss.css"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.assets[*].type", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"js", "js", "css"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.assets[*].scope", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"page", "page", "widget"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.assets[*].componentId", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"widget-id"})));
    }

    @Test
    public void should_increment_an_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset asset = AssetBuilder.anAsset().withComponentId("my-page").withOrder(3).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/assets/UIID?increment=true", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(asset))).andExpect(MockMvcResultMatchers.status().isOk());
        ((AssetService)Mockito.verify(this.pageAssetService)).changeAssetOrderInComponent((Assetable)page, "UIID", AssetService.OrderType.INCREMENT);
    }

    @Test
    public void should_decrement_an_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset asset = AssetBuilder.anAsset().withComponentId("my-page").withOrder(3).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/assets/UIID?decrement=true", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(asset))).andExpect(MockMvcResultMatchers.status().isOk());
        ((AssetService)Mockito.verify(this.pageAssetService)).changeAssetOrderInComponent((Assetable)page, "UIID", AssetService.OrderType.DECREMENT);
    }

    @Test
    public void should_delete_an_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/pages/my-page/assets/UIID", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((AssetService)Mockito.verify(this.pageAssetService)).delete((Assetable)page, "UIID");
    }

    @Test
    public void should_inactive_an_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset asset = AssetBuilder.anAsset().withComponentId(page.getId()).withOrder(3).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/assets/UIID?active=false", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(asset))).andExpect(MockMvcResultMatchers.status().isOk());
        ((AssetService)Mockito.verify(this.pageAssetService)).changeAssetStateInPreviewable((Assetable)page, "UIID", false);
    }

    @Test
    public void should_mark_a_page_as_favorite() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/favorite", (Object[])new Object[0]).contentType("application/json").content("true")).andExpect(MockMvcResultMatchers.status().isOk());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).markAsFavorite("my-page");
    }

    @Test
    public void should_unmark_a_page_as_favorite() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/pages/my-page/favorite", (Object[])new Object[0]).contentType("application/json").content("false")).andExpect(MockMvcResultMatchers.status().isOk());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).unmarkAsFavorite("my-page");
    }

    @Test
    public void should_load_page_asset_on_disk_with_content_type_text() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbLabel/pbLabel.js");
        Mockito.when((Object)this.pageAssetService.findAssetPath("page-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenReturn((Object)expectedFile);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/page-id/assets/js/asset.js?format=text", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"pbLabel.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_download_page_asset() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbLabel/pbLabel.js");
        Mockito.when((Object)this.pageAssetService.findAssetPath("page-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenReturn((Object)expectedFile);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/page-id/assets/js/asset.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.content().contentType("application/octet-stream")).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename=\"pbLabel.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_respond_404_when_widget_asset_included_in_page_is_not_found() throws Exception {
        Mockito.when((Object)this.pageAssetService.findAssetPath("page-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenReturn(null);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/page-id/assets/js/asset.js?format=text", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/page-id/assets/js/asset.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_500_when_widget_asset_included_in_page_produce_IOException() throws Exception {
        Mockito.when((Object)this.pageAssetService.findAssetPath("page-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenThrow(new Throwable[]{new IOException("can't read file")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/page-id/assets/js/asset.js?format=text", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/page-id/assets/js/asset.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    private Variable anApiVariable(String value) {
        return new Variable(DataType.URL, value);
    }

    private void setUpPageForResourcesTests() {
        this.page = this.mockPageOfId("myPage");
        Mockito.when((Object)this.componentVisitor.visit((Previewable)this.page)).thenReturn(Collections.emptyList());
        this.startProcessComponent = (Component)ComponentBuilder.aComponent().withPropertyValue("action", "constant", "Start process").build();
        this.submitTaskComponent = (Component)ComponentBuilder.aComponent().withPropertyValue("action", "constant", "Submit task").build();
    }

    @Test
    public void should_add_bonita_resources_found_in_pages_widgets() throws Exception {
        this.setUpPageForResourcesTests();
        TreeSet<String> authRules = new TreeSet<String>();
        authRules.add("GET|living/application-menu");
        authRules.add("POST|bpm/process");
        this.page.setVariables(Collections.singletonMap("foo", this.anApiVariable("../API/bpm/userTask?filter=mine")));
        Mockito.when((Object)this.authRulesCollector.visit((Previewable)this.page)).thenReturn(authRules);
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[GET|bpm/userTask, GET|living/application-menu, POST|bpm/process]"});
    }

    @Test
    public void should_add_bonita_api_extensions_resources_found_in_pages_widgets() throws Exception {
        this.setUpPageForResourcesTests();
        TreeSet<String> authRules = new TreeSet<String>();
        authRules.add("POST|bpm/process");
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        variables.put("foo", this.anApiVariable("../API/extension/CA31/SQLToObject?filter=mine"));
        variables.put("bar", this.anApiVariable("../API/extension/user/4"));
        variables.put("aa", this.anApiVariable("../API/extension/group/list"));
        variables.put("session", this.anApiVariable("../API/extension/user/group/unusedid"));
        variables.put("ab", this.anApiVariable("http://localhost:8080/bonita/portal/API/extension/vehicule/voiture/roue?p=0&c=10&f=case_id={{caseId}}"));
        variables.put("user", this.anApiVariable("../API/identity/user/{{aaa}}/context"));
        variables.put("task", this.anApiVariable("../API/bpm/task/1/context"));
        variables.put("case", this.anApiVariable("../API/bpm/case{{dynamicQueries(true,0)}}"));
        variables.put("custom", this.anApiVariable("../API/extension/case{{dynamicQueries}}"));
        this.page.setVariables(variables);
        Mockito.when((Object)this.authRulesCollector.visit((Previewable)this.page)).thenReturn(authRules);
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[GET|bpm/task, GET|identity/user, GET|bpm/case, GET|extension/group/list, GET|extension/vehicule/voiture/roue, GET|extension/user/4, GET|extension/user/group/unusedid, GET|extension/CA31/SQLToObject, GET|extension/case, POST|bpm/process]"});
    }

    @Test
    public void should_add_bonita_api_extensions_resources_found_in_page_data_table_properties() throws Exception {
        this.setUpPageForResourcesTests();
        Component dataTableComponent = (Component)ComponentBuilder.aComponent().withPropertyValue("apiUrl", "constant", "../API/extension/car").build();
        Mockito.when((Object)this.componentVisitor.visit((Previewable)this.page)).thenReturn(Collections.singleton(dataTableComponent));
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[GET|extension/car]"});
    }

    @Test
    public void should_add_bonita_api_extensions_resources_found_in_page_button_with_DELETE_action() throws Exception {
        this.setUpPageForResourcesTests();
        Component dataTableComponent = (Component)ComponentBuilder.aComponent().withPropertyValue("action", "constant", "DELETE").withPropertyValue("url", ParameterType.INTERPOLATION.getValue(), "../API/bpm/document/1").build();
        Mockito.when((Object)this.componentVisitor.visit((Previewable)this.page)).thenReturn(Collections.singleton(dataTableComponent));
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[DELETE|bpm/document]"});
    }

    @Test
    public void should_add_bonita_api_extensions_resources_found_in_page_button_with_POST_action() throws Exception {
        this.setUpPageForResourcesTests();
        Component dataTableComponent = (Component)ComponentBuilder.aComponent().withPropertyValue("action", "constant", "POST").withPropertyValue("url", ParameterType.INTERPOLATION.getValue(), "../API/extension/user").build();
        Mockito.when((Object)this.componentVisitor.visit((Previewable)this.page)).thenReturn(Collections.singleton(dataTableComponent));
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[POST|extension/user]"});
    }

    @Test
    public void should_add_bonita_api_extensions_resources_found_in_page_fileUpload_widget() throws Exception {
        this.setUpPageForResourcesTests();
        Component fileUploadComponent = (Component)ComponentBuilder.aComponent().withWidgetId("pbUpload").withPropertyValue("url", ParameterType.CONSTANT.getValue(), "../API/extension/upload").build();
        Mockito.when((Object)this.componentVisitor.visit((Previewable)this.page)).thenReturn(Collections.singleton(fileUploadComponent));
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[POST|extension/upload]"});
    }

    @Test
    public void should_add_start_process_resource_if_a_start_process_submit_is_contained_in_the_page() throws Exception {
        this.setUpPageForResourcesTests();
        Mockito.when((Object)this.componentVisitor.visit((Previewable)this.page)).thenReturn(Collections.singleton(this.startProcessComponent));
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[POST|bpm/process]"});
    }

    @Test
    public void should_show_the_correct_information_for_variables() throws Exception {
        Path expectedFilePath = Paths.get(this.getClass().getResource("/page-with-variables/").toURI()).resolve("page-with-variables.json");
        String expectedFileString = String.join((CharSequence)"", Files.readAllLines(expectedFilePath));
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        variables.put("constantVar", new Variable(DataType.CONSTANT, "constantVariableValue"));
        variables.put("jsonVar", new Variable(DataType.JSON, "{\"var1\":1, \"var2\":2, \"var3\":\"value3\"}"));
        variables.put("jsVar", new Variable(DataType.EXPRESSION, "var variable = \"hello\"; return variable;"));
        Page page = new Page();
        page.setId("page-with-variables");
        page.setVariables(variables);
        page.setDesignerVersion("1.10.6");
        page.setName("page");
        page.setLastUpdate(new Instant(1514989634397L));
        page.setRows(new ArrayList());
        page.setStatus(new MigrationStatusReport());
        Mockito.when((Object)this.pageService.get("id")).thenReturn((Object)page);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/pages/id", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(expectedFileString));
    }

    @Test
    public void should_add_submit_task_resource_if_a_start_submit_task_is_contained_in_the_page() throws Exception {
        this.setUpPageForResourcesTests();
        Mockito.when((Object)this.componentVisitor.visit((Previewable)this.page)).thenReturn(Collections.singleton(this.submitTaskComponent));
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[POST|bpm/userTask]"});
    }

    @Test
    public void should_combined_start_process_submit_task_and_bonita_resources() throws Exception {
        this.setUpPageForResourcesTests();
        Mockito.when((Object)this.componentVisitor.visit((Previewable)this.page)).thenReturn(Arrays.asList(this.startProcessComponent, this.submitTaskComponent));
        this.page.setVariables(Collections.singletonMap("foo", this.anApiVariable("/bonita/API/bpm/userTask")));
        String properties = new String(this.pageResource.getResources(this.page.getId()).toString());
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"[GET|bpm/userTask, POST|bpm/process, POST|bpm/userTask]"});
    }
}

