/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.export.ExportException;
import org.bonitasoft.web.designer.controller.export.Exporter;
import org.bonitasoft.web.designer.controller.export.Zipper;
import org.bonitasoft.web.designer.controller.export.steps.ExportStep;
import org.bonitasoft.web.designer.controller.utils.Unzipper;
import org.bonitasoft.web.designer.model.ModelException;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.Repository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.service.AbstractArtifactService;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.hamcrest.CoreMatchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class ExporterTest {
    @Rule
    public TemporaryFolder repositoryFolder = new TemporaryFolder();
    @Mock
    private PageRepository pageRepository;
    @Mock
    private PageService pageService;
    private Exporter<Page> exporter;
    private MockHttpServletResponse response = new MockHttpServletResponse();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.pageRepository.getComponentName()).thenReturn((Object)"page");
        this.exporter = new Exporter((Repository)this.pageRepository, (AbstractArtifactService)this.pageService, new ExportStep[]{(ExportStep)Mockito.mock(ExportStep.class)});
    }

    private Page create(Page page) throws IOException {
        if (page.getId() == null) {
            page.setId("default-id");
        }
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageService.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.resolvePath(page.getId())).thenReturn((Object)this.repositoryFolder.toPath());
        Files.write(this.repositoryFolder.toPath().resolve(String.format("%s.json", page.getId())), "foobar".getBytes(), new OpenOption[0]);
        return page;
    }

    private Path unzip(MockHttpServletResponse response) throws IOException {
        return new Unzipper().unzipInTempDir((InputStream)new ByteArrayInputStream(response.getContentAsByteArray()), "exportertest");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_exception_when_id_is_null() throws Exception {
        this.exporter.handleFileExport(null, (HttpServletResponse)this.response);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_exception_when_id_is_blank() throws Exception {
        this.exporter.handleFileExport(" ", (HttpServletResponse)this.response);
    }

    @Test
    public void should_throw_exception_when_artefact_to_export_is_not_found() throws Exception {
        NotFoundException cause = new NotFoundException("Page not found");
        Mockito.when((Object)this.pageService.get("unknown-id")).thenThrow(new Throwable[]{cause});
        this.exception.expect(ExportException.class);
        this.exception.expectCause(CoreMatchers.is((Object)cause));
        this.exporter.handleFileExport("unknown-id", (HttpServletResponse)this.response);
    }

    @Test
    public void should_set_zip_content_type_to_response() throws Exception {
        Page page = this.create(PageBuilder.aPage().build());
        this.exporter.handleFileExport(page.getId(), (HttpServletResponse)this.response);
        Assertions.assertThat((String)this.response.getContentType()).isEqualTo((Object)"application/zip");
    }

    @Test(expected=ModelException.class)
    public void should_failed_when_page_is_not_compatible_with_product_model_version() throws Exception {
        Page page = this.create(PageBuilder.aPage().withModelVersion("5.0").isCompatible(false).build());
        this.exporter.handleFileExport(page.getId(), (HttpServletResponse)this.response);
    }

    @Test
    public void should_set_formatted_filename_in_header() throws Exception {
        Page page = this.create(PageBuilder.aPage().withName("\u00e9&az zer/\u00e8\"").build());
        this.exporter.handleFileExport(page.getId(), (HttpServletResponse)this.response);
        Assertions.assertThat((String)this.response.getHeader("Content-Disposition")).isEqualTo((Object)"inline; filename=page-az-zer.zip;");
    }

    @Test
    public void should_set__artifact_type_in_filename() throws Exception {
        Page page = this.create(PageBuilder.aPage().withType("layout").withName("thelayout").build());
        this.exporter.handleFileExport(page.getId(), (HttpServletResponse)this.response);
        Assertions.assertThat((String)this.response.getHeader("Content-Disposition")).isEqualTo((Object)"inline; filename=layout-thelayout.zip;");
    }

    @Test
    public void should_export_json_model_of_the_exported_artefact() throws Exception {
        Page page = this.create(PageBuilder.aPage().withId("myPage").build());
        this.exporter.handleFileExport(page.getId(), (HttpServletResponse)this.response);
        Path unzipped = this.unzip(this.response);
        Assertions.assertThat((byte[])Files.readAllBytes(unzipped.resolve("resources/page.json"))).isEqualTo((Object)"foobar".getBytes());
        FileUtils.deleteDirectory((File)unzipped.toFile());
    }

    @Test
    public void should_execute_export_steps() throws Exception {
        FakeStep fakeStep1 = new FakeStep("This is some content", "resources/file1.json");
        FakeStep fakeStep2 = new FakeStep("This is another content", "resources/deep/file2.json");
        Exporter exporter = new Exporter((Repository)this.pageRepository, (AbstractArtifactService)this.pageService, new ExportStep[]{fakeStep1, fakeStep2});
        Page page = this.create(PageBuilder.aPage().build());
        exporter.handleFileExport(page.getId(), (HttpServletResponse)this.response);
        Path unzipped = this.unzip(this.response);
        Assertions.assertThat((byte[])Files.readAllBytes(unzipped.resolve("resources/file1.json"))).isEqualTo((Object)"This is some content".getBytes());
        Assertions.assertThat((byte[])Files.readAllBytes(unzipped.resolve("resources/deep/file2.json"))).isEqualTo((Object)"This is another content".getBytes());
        FileUtils.deleteDirectory((File)unzipped.toFile());
    }

    private class FakeStep
    implements ExportStep<Page> {
        private String content;
        private String filename;

        public FakeStep(String content, String filename) {
            this.content = content;
            this.filename = filename;
        }

        public void execute(Zipper zipper, Page page) throws IOException {
            zipper.addToZip(this.content.getBytes(), this.filename);
        }
    }
}

