/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.controller.export.ExcludeDescriptorFilePredicate;
import org.bonitasoft.web.designer.controller.export.IncludeChildDirectoryPredicate;
import org.bonitasoft.web.designer.controller.export.Zipper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.zeroturnaround.zip.ZipUtil;

public class ZipperTest {
    private Zipper zipper;
    private ByteArrayOutputStream out;
    private Path tmpDir;
    private URI dir;

    @Before
    public void setUp() throws Exception {
        this.out = new ByteArrayOutputStream();
        this.zipper = new Zipper((OutputStream)this.out);
        this.dir = this.getClass().getResource("/aDirectory").toURI();
    }

    @After
    public void tearDown() throws IOException {
        this.zipper.close();
        this.out.close();
        if (this.tmpDir != null) {
            FileUtils.deleteQuietly((File)this.tmpDir.toFile());
        }
    }

    private Path unzip(ByteArrayOutputStream out) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
        this.tmpDir = Files.createTempDirectory("testZip", new FileAttribute[0]);
        ZipUtil.unpack((InputStream)byteArrayInputStream, (File)this.tmpDir.toFile());
        return this.tmpDir;
    }

    private void expectSameDirContent(final Path actual, final Path expected) throws IOException {
        Files.walkFileTree(actual, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path expectedFile = expected.resolve(actual.relativize(file));
                Assertions.assertThat((File)expectedFile.toFile()).exists();
                Assertions.assertThat((File)expectedFile.toFile()).hasContent(new String(Files.readAllBytes(expectedFile)));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path expectedDir = expected.resolve(actual.relativize(dir));
                Assertions.assertThat((File)expectedDir.toFile()).exists();
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Test
    public void should_zip_a_directory() throws Exception {
        this.zipper.addDirectoryToZip(Paths.get(this.dir), Zipper.ALL_DIRECTORIES, Zipper.ALL_FILES, "");
        Path dest = this.unzip(this.out);
        this.expectSameDirContent(dest, Paths.get(this.dir));
    }

    @Test
    public void should_zip_a_directory_in_a_destination_folder_without_filter() throws Exception {
        this.zipper.addDirectoryToZip(Paths.get(this.dir), Zipper.ALL_DIRECTORIES, Zipper.ALL_FILES, "destinationInZip");
        Path dest = this.unzip(this.out);
        this.expectSameDirContent(dest.resolve("destinationInZip"), Paths.get(this.dir));
    }

    @Test
    public void should_zip_a_directory_in_a_destination_folder() throws Exception {
        this.zipper.addDirectoryToZip(Paths.get(this.dir), (Zipper.PathPredicate)new IncludeChildDirectoryPredicate(Paths.get(this.dir), Collections.singleton("aSubDirectory")), Zipper.ALL_FILES, "destinationInZip");
        Path dest = this.unzip(this.out);
        this.expectSameDirContent(dest.resolve("destinationInZip"), Paths.get(this.dir));
    }

    @Test
    public void should_zipentry_contains_paths_instead_of_file_separators() throws Exception {
        this.zipper.addDirectoryToZip(Paths.get(this.dir), (Zipper.PathPredicate)new IncludeChildDirectoryPredicate(Paths.get(this.dir), Collections.singleton("aSubDirectory")), Zipper.ALL_FILES, "destinationInZip");
        Set<String> entries = this.zipEntries(this.out);
        Assertions.assertThat(entries).contains((Object[])new String[]{"destinationInZip/aFile.txt"});
    }

    private Set<String> zipEntries(ByteArrayOutputStream out) throws IOException {
        HashSet<String> entries = new HashSet<String>();
        try (ZipInputStream zipFile = new ZipInputStream(new ByteArrayInputStream(out.toByteArray()));){
            ZipEntry entry;
            while ((entry = zipFile.getNextEntry()) != null) {
                entries.add(entry.getName());
            }
        }
        return entries;
    }

    @Test
    public void should_zip_a_directory_and_filter_out_unaccepted_subdirectories() throws Exception {
        String destinationInZip = "destinationInZip";
        this.zipper.addDirectoryToZip(Paths.get(this.dir), (Zipper.PathPredicate)new IncludeChildDirectoryPredicate(Paths.get(this.dir), Collections.singleton("nonExisting")), Zipper.ALL_FILES, destinationInZip);
        Path dest = this.unzip(this.out);
        Assertions.assertThat((Object[])dest.resolve(destinationInZip).toFile().list()).containsExactly((Object[])new String[]{"aFile.txt"});
    }

    @Test
    public void should_zip_a_directory_and_filter_out_unaccepted_descriptorjsonfile() throws Exception {
        String destinationInZip = "destinationInZip";
        this.zipper.addDirectoryToZip(Paths.get(this.getClass().getResource("/workspace/widgets/pbLabel").toURI()), Zipper.ALL_DIRECTORIES, (Zipper.FilePredicate)new ExcludeDescriptorFilePredicate("pbLabel.json"), destinationInZip);
        Path dest = this.unzip(this.out);
        Assertions.assertThat((Object[])dest.resolve(destinationInZip).toFile().list()).doesNotContain((Object[])new String[]{"pbLabel.json"});
    }

    @Test
    public void should_zip_some_bytes() throws Exception {
        byte[] foo = "foobar".getBytes(StandardCharsets.UTF_8);
        this.zipper.addToZip(foo, "foo.txt");
        Path dest = this.unzip(this.out);
        Assertions.assertThat((File)dest.resolve("foo.txt").toFile()).exists();
        Assertions.assertThat((File)dest.resolve("foo.txt").toFile()).usingCharset(StandardCharsets.UTF_8).hasContent("foobar");
    }

    @Test
    public void should_close_stream() throws Exception {
        ByteArrayOutputStream out = (ByteArrayOutputStream)Mockito.mock(ByteArrayOutputStream.class);
        Zipper zipper = new Zipper((OutputStream)out);
        zipper.close();
        ((ByteArrayOutputStream)Mockito.verify((Object)out)).flush();
        ((ByteArrayOutputStream)Mockito.verify((Object)out)).close();
    }
}

