/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.controller.MigrationResource;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.controller.importer.ArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ServerImportException;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.DependencyImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.WidgetImporter;
import org.bonitasoft.web.designer.controller.importer.exception.ImportExceptionMatcher;
import org.bonitasoft.web.designer.controller.importer.mocks.PageImportMock;
import org.bonitasoft.web.designer.controller.importer.mocks.WidgetImportMock;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.repository.Loader;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.Repository;
import org.bonitasoft.web.designer.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.service.AbstractArtifactService;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ArtifactImporterTest {
    private static final String WIDGETS_FOLDER = "widgets";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    @Mock
    private PageRepository pageRepository;
    @Mock
    private PageService pageService;
    @Mock
    private MigrationResource migrationResource;
    @Mock
    private JsonFileBasedLoader<Page> pageLoader;
    @Mock
    private WidgetFileBasedLoader widgetLoader;
    @Mock
    private WidgetRepository widgetRepository;
    private ArtifactImporter<Page> pageImporter;
    private ArtifactImporter<Widget> widgetImporter;
    private Path pageImportPath;
    private Path widgetImportPath;
    private Path pageUnzippedPath;
    private Path widgetUnzippedPath;
    private WidgetImportMock wMocks;
    private PageImportMock pMocks;

    @Before
    public void setUp() throws IOException {
        this.pageImportPath = Files.createTempDirectory(this.tempDir.toPath(), "pageImport", new FileAttribute[0]);
        this.widgetImportPath = Files.createTempDirectory(this.tempDir.toPath(), "widgetImport", new FileAttribute[0]);
        WidgetImporter widgetDependencyImporter = new WidgetImporter(this.widgetLoader, this.widgetRepository, (AssetImporter)Mockito.mock(AssetImporter.class));
        this.pageImporter = new ArtifactImporter((Repository)this.pageRepository, (AbstractArtifactService)this.pageService, this.pageLoader, new DependencyImporter[]{widgetDependencyImporter});
        this.widgetImporter = new ArtifactImporter((Repository)this.widgetRepository, null, (Loader)this.widgetLoader, new DependencyImporter[0]);
        this.pageUnzippedPath = this.pageImportPath.resolve("resources");
        Files.createDirectory(this.pageUnzippedPath, new FileAttribute[0]);
        Mockito.when((Object)this.pageRepository.getComponentName()).thenReturn((Object)"page");
        this.widgetUnzippedPath = this.widgetImportPath.resolve("resources");
        Files.createDirectory(this.widgetUnzippedPath, new FileAttribute[0]);
        Mockito.when((Object)this.widgetRepository.getComponentName()).thenReturn((Object)"widget");
        this.wMocks = new WidgetImportMock(this.pageUnzippedPath, this.widgetLoader, this.widgetRepository);
        this.pMocks = new PageImportMock(this.pageUnzippedPath, this.pageLoader);
    }

    @Test
    public void should_import_artifact_located_on_disk() throws Exception {
        List<Widget> widgets = this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        this.pageImporter.doImport(this.anImport(this.pageImportPath));
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).saveAll(widgets);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_return_an_import_report_containing_imported_element_and_imported_dependencies() throws Exception {
        List<Widget> addedWidgets = this.wMocks.mockWidgetsAsAddedDependencies();
        List<Widget> overridenWidgets = this.wMocks.mockWidgetsAsOverridenDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        ImportReport report = this.pageImporter.doImport(this.anImport(this.pageImportPath));
        Assertions.assertThat((List)((List)report.getDependencies().getAdded().get("widget"))).isEqualTo(addedWidgets);
        Assertions.assertThat((List)((List)report.getDependencies().getOverwritten().get("widget"))).isEqualTo(overridenWidgets);
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)page);
    }

    @Test
    public void should_return_an_import_report_saying_that_page_is_going_to_be_overwritten_when_element_already_exists_in_repository() throws Exception {
        Page page = this.pMocks.mockPageToBeImported();
        Page existingPageInRepo = PageBuilder.aPage().withUUID(page.getUUID()).withName("alreadyHere").build();
        Mockito.when((Object)this.pageRepository.getByUUID(page.getUUID())).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)this.pageRepository.get(existingPageInRepo.getId())).thenReturn((Object)existingPageInRepo);
        ImportReport report = this.pageImporter.doImport(this.anImport(this.pageImportPath));
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)page);
        Assertions.assertThat((Object)report.getOverwrittenElement()).isEqualTo((Object)existingPageInRepo);
        Assertions.assertThat((Boolean)report.isOverwritten()).isTrue();
    }

    @Test
    public void should_return_an_import_report_saying_that_widget_is_going_to_be_overwritten_when_element_already_exists_in_repository() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("aWidget").custom().build();
        Widget existingWidgetInRepo = WidgetBuilder.aWidget().id("aWidget").favorite().custom().build();
        Mockito.when((Object)this.widgetLoader.load(this.widgetUnzippedPath.resolve("widget.json"))).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetRepository.exists(widget.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.widgetRepository.get(widget.getId())).thenReturn((Object)existingWidgetInRepo);
        ImportReport report = this.widgetImporter.doImport(this.anImport(this.widgetImportPath));
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)existingWidgetInRepo);
        Assertions.assertThat((Boolean)report.isOverwritten()).isTrue();
    }

    @Test
    public void should_return_an_import_report_saying_that_element_has_not_been_overwritten_when_element_does_not_exists_in_repository() throws Exception {
        Page page = this.pMocks.mockPageToBeImported();
        Mockito.when((Object)this.pageRepository.getByUUID(page.getUUID())).thenReturn(null);
        ImportReport report = this.pageImporter.doImport(this.anImport(this.pageImportPath));
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)page);
        Assertions.assertThat((Boolean)report.isOverwritten()).isFalse();
        Assertions.assertThat((Object)report.getOverwrittenElement()).isNull();
    }

    @Test
    public void should_return_an_import_report_saying_that_element_has_been_imported_when_there_are_no_conflict() throws Exception {
        List<Widget> widgets = this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        ImportReport report = this.pageImporter.doImport(this.anImport(this.pageImportPath));
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.IMPORTED);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).saveAll(widgets);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_return_an_import_report_saying_that_element_has_not_been_imported_when_there_are_conflict() throws Exception {
        List<Widget> overriddenWidgets = this.wMocks.mockWidgetsAsOverridenDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        ImportReport report = this.pageImporter.doImport(this.anImport(this.pageImportPath));
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.CONFLICT);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository, (VerificationMode)Mockito.never())).saveAll(overriddenWidgets);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_throw_import_exception_when_there_is_no_resource_folder_in_import_path() throws Exception {
        Path newFolder = this.tempDir.newFolderPath("emptyFolder");
        this.exception.expect(ImportException.class);
        this.exception.expect((Matcher)ImportExceptionMatcher.hasType(ImportException.Type.UNEXPECTED_ZIP_STRUCTURE));
        this.pageImporter.doImport(this.anImport(newFolder));
    }

    @Test(expected=ServerImportException.class)
    public void should_throw_server_import_exception_when_error_occurs_while_saving_files_in_repository() throws Exception {
        Page page = PageBuilder.aPage().withId("aPage").build();
        Mockito.when((Object)this.pageLoader.load(this.pageUnzippedPath.resolve("page.json"))).thenReturn((Object)page);
        ((PageRepository)Mockito.doThrow(RepositoryException.class).when((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
        this.pageImporter.doImport(this.anImport(this.pageImportPath));
    }

    @Test(expected=ServerImportException.class)
    public void should_throw_import_exception_when_an_error_occurs_while_getting_widgets() throws Exception {
        Files.createDirectory(this.pageUnzippedPath.resolve(WIDGETS_FOLDER), new FileAttribute[0]);
        Mockito.when((Object)this.widgetLoader.loadAllCustom(this.pageUnzippedPath.resolve(WIDGETS_FOLDER))).thenThrow(new Throwable[]{new IOException()});
        this.pageImporter.doImport(this.anImport(this.pageImportPath));
    }

    private Import anImport(Path path) {
        return new Import(this.pageImporter, "import-uuid", path);
    }

    @Test
    public void should_force_an_import() throws Exception {
        List<Widget> addedWidgets = this.wMocks.mockWidgetsAsAddedDependencies();
        List<Widget> overriddenWidgets = this.wMocks.mockWidgetsAsOverridenDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        Mockito.when((Object)this.pageRepository.exists(page.getId())).thenReturn((Object)false);
        Import anImport = new Import(this.pageImporter, "import-uuid", this.pageImportPath);
        ImportReport report = this.pageImporter.forceImport(anImport);
        Assertions.assertThat((List)((List)report.getDependencies().getAdded().get("widget"))).isEqualTo(addedWidgets);
        Assertions.assertThat((List)((List)report.getDependencies().getOverwritten().get("widget"))).isEqualTo(overriddenWidgets);
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)page);
        Assertions.assertThat((String)report.getUUID()).isEqualTo((Object)anImport.getUUID());
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.IMPORTED);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository, (VerificationMode)Mockito.never())).saveAll(overriddenWidgets);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)Matchers.any(Page.class));
    }

    @Test
    public void should_force_an_import_overwriting_page() throws Exception {
        this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        Page existingPageInRepo = PageBuilder.aPage().withUUID(page.getUUID()).withId("alreadyHere").withName("alreadyHere").build();
        Mockito.when((Object)this.pageRepository.getByUUID(page.getUUID())).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)this.pageRepository.get(existingPageInRepo.getId())).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)this.pageRepository.exists(page.getId())).thenReturn((Object)false);
        Import anImport = new Import(this.pageImporter, "import-uuid", this.pageImportPath);
        ImportReport report = this.pageImporter.forceImport(anImport);
        Assertions.assertThat((Object)report.getOverwrittenElement()).isEqualTo((Object)existingPageInRepo);
        Assertions.assertThat((Boolean)report.isOverwritten()).isTrue();
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.IMPORTED);
        Assertions.assertThat((String)page.getId()).isEqualTo((Object)"id");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).delete(existingPageInRepo.getId());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)Matchers.any(Page.class));
    }

    @Test
    public void should_force_an_import_when_another_page_with_same_id_exist() throws Exception {
        this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        page.setName("myPage");
        Page existingPageInRepo = PageBuilder.aPage().withUUID(page.getUUID()).withId("alreadyHere").withName("alreadyHere").build();
        Mockito.when((Object)this.pageRepository.getByUUID(page.getUUID())).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)this.pageRepository.get(existingPageInRepo.getId())).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)this.pageRepository.exists(page.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.pageRepository.getNextAvailableId(page.getName())).thenReturn((Object)"myPage1");
        Import anImport = new Import(this.pageImporter, "import-uuid", this.pageImportPath);
        ImportReport report = this.pageImporter.forceImport(anImport);
        Assertions.assertThat((Object)report.getOverwrittenElement()).isEqualTo((Object)existingPageInRepo);
        Assertions.assertThat((Boolean)report.isOverwritten()).isTrue();
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.IMPORTED);
        Assertions.assertThat((String)page.getId()).isEqualTo((Object)"myPage1");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).delete(existingPageInRepo.getId());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)Matchers.any(Page.class));
    }

    @Test
    public void should_return_incompatible_status_if_version_is_not_compatible_with_uid() throws Exception {
        this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        page.setName("myPage");
        page.setId("myPage");
        page.setModelVersion("12.0.0");
        Mockito.when((Object)this.pageRepository.getNextAvailableId(page.getName())).thenReturn((Object)"myPage1");
        Import anImport = new Import(this.pageImporter, "import-uuid", this.pageImportPath);
        Mockito.when((Object)this.pageService.getStatusWithoutDependencies((Identifiable)page)).thenReturn((Object)new MigrationStatusReport(false, false));
        ImportReport report = this.pageImporter.doImport(anImport);
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.INCOMPATIBLE);
        Assertions.assertThat((String)page.getId()).isEqualTo((Object)"myPage");
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)Matchers.any(Page.class));
    }
}

