/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.preview;

import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.preview.Previewer;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.rendering.GenerationException;
import org.bonitasoft.web.designer.rendering.HtmlGenerator;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.Repository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class PreviewerTest
extends TestCase {
    @Mock
    private PageRepository pageRepository;
    @Mock
    private HtmlGenerator generator;
    @InjectMocks
    private Previewer previewer;
    private MockHttpServletRequest request = new MockHttpServletRequest();
    private Page page = PageBuilder.aPage().withId("a-page").build();

    @Test
    public void should_generate_html_and_print_it_in_response() throws Exception {
        Mockito.when((Object)this.pageRepository.get(this.page.getId())).thenReturn((Object)this.page);
        Mockito.when((Object)this.generator.generateHtml("/runtime/", (Previewable)this.page)).thenReturn((Object)"foobar");
        ResponseEntity response = this.previewer.render(this.page.getId(), (Repository)this.pageRepository, (HttpServletRequest)this.request);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((String)((String)response.getBody())).isEqualTo((Object)"foobar");
    }

    @Test
    public void should_return_error_response_when_error_occur_on_generation() throws Exception {
        Mockito.when((Object)this.pageRepository.get(this.page.getId())).thenReturn((Object)this.page);
        Mockito.when((Object)this.generator.generateHtml("/runtime/", (Previewable)this.page)).thenThrow(new Throwable[]{new GenerationException("error", (Throwable)new Exception())});
        ResponseEntity response = this.previewer.render(this.page.getId(), (Repository)this.pageRepository, (HttpServletRequest)this.request);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.INTERNAL_SERVER_ERROR);
        Assertions.assertThat((String)((String)response.getBody())).isEqualTo((Object)"Error during page generation");
    }

    @Test
    public void should_return_error_response_when_page_is_not_found() throws Exception {
        Mockito.when((Object)this.pageRepository.get("unexisting-page")).thenThrow(new Throwable[]{new NotFoundException("page not found")});
        ResponseEntity response = this.previewer.render("unexisting-page", (Repository)this.pageRepository, (HttpServletRequest)this.request);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.NOT_FOUND);
        Assertions.assertThat((String)((String)response.getBody())).isEqualTo((Object)"Page <unexisting-page> not found");
    }
}

