/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.generator.mapping.data.FormOutputVisitor;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.Contract;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.ContractInputVisitor;
import org.bonitasoft.web.designer.model.contract.builders.ContractBuilder;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.junit.Test;

public class FormOutputVisitorTest {
    FormOutputVisitor visitor = new FormOutputVisitor();

    @Test
    public void should_build_form_output_from_simple_types() throws Exception {
        Contract contract = ContractBuilder.aContract().withInput(new ContractInput[]{ContractInputBuilder.aBooleanContractInput((String)"accepted")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJavascriptExpression()).isEqualTo((Object)"return {\n\taccepted: $data.formInput.accepted\n}");
    }

    @Test
    public void should_build_form_output_from_complex_types() throws Exception {
        Contract contract = ContractBuilder.aContract().inEditMode().withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"person").withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"name"), ContractInputBuilder.aNodeContractInput((String)"details").withInput(new ContractInput[]{ContractInputBuilder.anIntegerContractInput((String)"age")}).build()}).build(), ContractInputBuilder.aBooleanContractInput((String)"accepted")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJavascriptExpression()).isEqualTo((Object)"return {\n\tperson: $data.formInput.person,\n\taccepted: $data.formInput.accepted\n}");
    }

    @Test
    public void should_build_form_output_from_complex_types_with_data_reference() throws Exception {
        Contract contract = ContractBuilder.aContract().inEditMode().withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"person").withDataReference(new BusinessDataReference("person", "org.test.Person", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"name"), ContractInputBuilder.aNodeContractInput((String)"details").mulitple().withDataReference(new BusinessDataReference("details", "org.test.Detail", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).withInput(new ContractInput[]{ContractInputBuilder.anIntegerContractInput((String)"age")}).build()}).build(), ContractInputBuilder.aBooleanContractInput((String)"accepted")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJavascriptExpression()).isEqualTo((Object)"if( $data.person ){\n\treturn {\n\t\t//map person variable to expected task contract input\n\t\tperson: {\n\t\t\tname: $data.person.name !== undefined ? $data.person.name : null,\n\t\t\tdetails: $data.person.details.map( it => ({\n\t\t\t\tage: it.age !== undefined ? it.age : null\n\t\t\t}))\n\t\t},\n\t\taccepted: $data.formInput.accepted\n\t}\n}");
    }

    @Test
    public void should_build_form_output_from_complex_types_with_lazy_data_reference() throws Exception {
        Contract contract = ContractBuilder.aContract().inEditMode().withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"personInput").withDataReference(new BusinessDataReference("person", "org.test.Person", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"name"), ContractInputBuilder.aNodeContractInput((String)"detail").withDataReference(new BusinessDataReference("detail", "org.test.Detail", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.LAZY)).withInput(new ContractInput[]{ContractInputBuilder.anIntegerContractInput((String)"age"), ContractInputBuilder.aStringContractInput((String)"carnation")}).build()}).build(), ContractInputBuilder.aBooleanContractInput((String)"accepted")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJavascriptExpression()).isEqualTo((Object)"if( $data.person && $data.person_detail ){\n\t//attach lazy references variables to parent variables\n\t$data.person.detail = $data.person_detail;\n\treturn {\n\t\t//map person variable to expected task contract input\n\t\tpersonInput: {\n\t\t\tname: $data.person.name !== undefined ? $data.person.name : null,\n\t\t\tdetail: $data.person.detail ? {\n\t\t\t\tage: $data.person.detail.age !== undefined ? $data.person.detail.age : null,\n\t\t\t\tcarnation: $data.person.detail.carnation !== undefined ? $data.person.detail.carnation : null\n\t\t\t} : null\n\t\t},\n\t\taccepted: $data.formInput.accepted\n\t}\n}");
    }

    @Test
    public void should_build_form_output_from_multiple_complex_types_with_data_reference() throws Exception {
        Contract contract = ContractBuilder.aContract().inEditMode().withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"persons").mulitple().withDataReference(new BusinessDataReference("persons", "org.test.Person", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"name"), ContractInputBuilder.aNodeContractInput((String)"details").mulitple().withDataReference(new BusinessDataReference("details", "org.test.Detail", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).withInput(new ContractInput[]{ContractInputBuilder.anIntegerContractInput((String)"age")}).build()}).build(), ContractInputBuilder.aBooleanContractInput((String)"accepted")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJavascriptExpression()).isEqualTo((Object)"if( $data.persons ){\n\treturn {\n\t\t//map persons variable to expected task contract input\n\t\tpersons: $data.persons.map( it => ({\n\t\t\tname: it.name !== undefined ? it.name : null,\n\t\t\tdetails: it.details.map( it => ({\n\t\t\t\tage: it.age !== undefined ? it.age : null\n\t\t\t}))\n\t\t})),\n\t\taccepted: $data.formInput.accepted\n\t}\n}");
    }
}

