/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping.dataManagement;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.generator.mapping.DimensionFactory;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.BusinessDataToWidgetMapper;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.BusinessObjectContainer;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.NodeBusinessObjectInput;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.DataReference;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.junit.Test;

public class BusinessDataToWidgetMapperTest {
    @Test
    public void should_string_contract_input_create_an_input_widget_id() throws Exception {
        BusinessDataToWidgetMapper contractInputToWidgetMapper = this.makeBusinessDataToWidgetMapper(new BusinessObjectContainer());
        List element = contractInputToWidgetMapper.toElement(ContractInputBuilder.aStringContractInput((String)"firstName"));
        Component a = (Component)element.get(0);
        Assertions.assertThat((String)a.getId()).isEqualTo((Object)"pbInput");
    }

    @Test
    public void should_configure_value_property_of_input_with_$item_when_generating_a_multiple_string_in_a_multiple_leaf_contract_input() {
        BusinessDataToWidgetMapper businessDataToWidgetMapper = this.makeBusinessDataToWidgetMapper(new BusinessObjectContainer());
        ContractInput contractInput = ContractInputBuilder.aContractInput((String)"names").mulitple().withType(String.class.getName()).build();
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.company.model.person", "person");
        node.setMultiple(true);
        node.addInput(contractInput);
        List elements = businessDataToWidgetMapper.toElement((LeafContractInput)contractInput);
        Container container = (Container)elements.get(1);
        Assertions.assertThat((Object)container).isInstanceOf(Container.class);
        PropertyValue repeatedCollectionPropetyValue = (PropertyValue)container.getPropertyValues().get("repeatedCollection");
        Assertions.assertThat((String)repeatedCollectionPropetyValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)repeatedCollectionPropetyValue.getValue()).isEqualTo((Object)"person_selected.names");
        Element input = (Element)((List)container.getRows().get(0)).get(0);
        PropertyValue inputPropertyValue = (PropertyValue)input.getPropertyValues().get("value");
        Assertions.assertThat((Object)inputPropertyValue.getValue()).isEqualTo((Object)"$item");
    }

    @Test
    public void should_generate_title_and_table_widgets_pattern_when_node_is_read() {
        BusinessObjectContainer boc = new BusinessObjectContainer();
        BusinessDataToWidgetMapper businessDataToWidgetMapper = this.makeBusinessDataToWidgetMapper(boc);
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.company.model.person", "person");
        node.addInput(ContractInputBuilder.aContractInput((String)"addresses").mulitple().withType(String.class.getName()).build());
        node.addInput(ContractInputBuilder.aContractInput((String)"firstName").withType(String.class.getName()).build());
        node.addInput(ContractInputBuilder.aContractInput((String)"lastName").withType(String.class.getName()).build());
        businessDataToWidgetMapper.generateMasterDetailsPattern(node, boc.getContainer().getRows());
        Component title = (Component)((List)boc.getContainer().getRows().get(0)).get(0);
        Assertions.assertThat((String)title.getId()).isEqualTo((Object)"pbTitle");
        PropertyValue titleCollectionPropertyValue = (PropertyValue)title.getPropertyValues().get("text");
        Assertions.assertThat((String)titleCollectionPropertyValue.getType()).isEqualTo((Object)"interpolation");
        Assertions.assertThat((Object)titleCollectionPropertyValue.getValue()).isEqualTo((Object)"Person");
        Component tableWidget = (Component)((List)boc.getContainer().getRows().get(1)).get(0);
        Assertions.assertThat((String)tableWidget.getId()).isEqualTo((Object)"pbTable");
        Map variables = boc.getBusinessObjectVariable();
        Assertions.assertThat((int)variables.size()).isEqualTo(1);
        Assertions.assertThat(variables.get("person_selected")).isNotNull();
    }

    @Test
    public void should_generate_external_url_on_master_details_pattern_when_nested_object_is_lazy_loading() {
        BusinessObjectContainer boc = new BusinessObjectContainer();
        BusinessDataToWidgetMapper businessDataToWidgetMapper = this.makeBusinessDataToWidgetMapper(boc);
        NodeBusinessObjectInput childNode = this.aNestedObjectInLazyAggregation(true);
        childNode.setMultiple(true);
        businessDataToWidgetMapper.generateMasterDetailsPattern(childNode, boc.getContainer().getRows());
        Component title = (Component)((List)boc.getContainer().getRows().get(0)).get(0);
        Assertions.assertThat((String)title.getId()).isEqualTo((Object)"pbTitle");
        PropertyValue titleCollectionPropertyValue = (PropertyValue)title.getPropertyValues().get("text");
        Assertions.assertThat((String)titleCollectionPropertyValue.getType()).isEqualTo((Object)"interpolation");
        Assertions.assertThat((Object)titleCollectionPropertyValue.getValue()).isEqualTo((Object)"Addresses");
        Component tableWidget = (Component)((List)boc.getContainer().getRows().get(1)).get(0);
        Assertions.assertThat((String)tableWidget.getId()).isEqualTo((Object)"pbTable");
        Map tableCollectionPropertyValue = tableWidget.getPropertyValues();
        Assertions.assertThat((Object)((PropertyValue)tableCollectionPropertyValue.get("content")).getValue()).isEqualTo((Object)"customer_addresses");
        Assertions.assertThat((Object)((PropertyValue)tableCollectionPropertyValue.get("selectedRow")).getValue()).isEqualTo((Object)"customer_addresses_selected");
        Assertions.assertThat((Object)((PropertyValue)tableCollectionPropertyValue.get("headers")).getValue()).isEqualTo(Arrays.asList("Addresses"));
        Map variables = boc.getBusinessObjectVariable();
        Assertions.assertThat((int)variables.size()).isEqualTo(2);
        Assertions.assertThat(variables.get("customer_addresses_selected")).isNotNull();
        Assertions.assertThat((Comparable)((Variable)variables.get("customer_addresses")).getType()).isEqualTo((Object)DataType.URL);
        Assertions.assertThat((String)((String)((Variable)variables.get("customer_addresses")).getValue().get(0))).isEqualTo((Object)"{{customer_selected|lazyRef:'addresses'}}");
    }

    @Test
    public void should_generate_master_details_when_nested_object_is_loading_on_composition_and_eager() {
        BusinessObjectContainer boc = new BusinessObjectContainer();
        BusinessDataToWidgetMapper businessDataToWidgetMapper = this.makeBusinessDataToWidgetMapper(boc);
        NodeBusinessObjectInput node = this.aNestedObjectInCompositionAndEager();
        node.setMultiple(true);
        businessDataToWidgetMapper.generateMasterDetailsPattern(node, boc.getContainer().getRows());
        Component title = (Component)((List)boc.getContainer().getRows().get(0)).get(0);
        Assertions.assertThat((String)title.getId()).isEqualTo((Object)"pbTitle");
        PropertyValue titleCollectionPropertyValue = (PropertyValue)title.getPropertyValues().get("text");
        Assertions.assertThat((String)titleCollectionPropertyValue.getType()).isEqualTo((Object)"interpolation");
        Assertions.assertThat((Object)titleCollectionPropertyValue.getValue()).isEqualTo((Object)"Sport");
        Component tableWidget = (Component)((List)boc.getContainer().getRows().get(1)).get(0);
        Assertions.assertThat((String)tableWidget.getId()).isEqualTo((Object)"pbTable");
        Map tableCollectionPropertyValue = tableWidget.getPropertyValues();
        Assertions.assertThat((Object)((PropertyValue)tableCollectionPropertyValue.get("content")).getValue()).isEqualTo((Object)"person_selected.sport");
        Assertions.assertThat((Object)((PropertyValue)tableCollectionPropertyValue.get("selectedRow")).getValue()).isEqualTo((Object)"person_sport_selected");
        Assertions.assertThat((Object)((PropertyValue)tableCollectionPropertyValue.get("headers")).getValue()).isEqualTo(Arrays.asList("Name", "Need Balls"));
        Map variables = boc.getBusinessObjectVariable();
        Assertions.assertThat((int)variables.size()).isEqualTo(1);
        Assertions.assertThat(variables.get("person_sport_selected")).isNotNull();
    }

    @Test
    public void should_not_generate_table_widget_when_child_object_is_not_multiple() {
        BusinessObjectContainer boc = new BusinessObjectContainer();
        BusinessDataToWidgetMapper businessDataToWidgetMapper = this.makeBusinessDataToWidgetMapper(boc);
        NodeBusinessObjectInput childNode = this.aNestedObjectInLazyAggregation(true);
        childNode.setMultiple(false);
        businessDataToWidgetMapper.generateMasterDetailsPattern(childNode, boc.getContainer().getRows());
        Component title = (Component)((List)boc.getContainer().getRows().get(0)).get(0);
        Assertions.assertThat((String)title.getId()).isEqualTo((Object)"pbTitle");
        PropertyValue titleCollectionPropertyValue = (PropertyValue)title.getPropertyValues().get("text");
        Assertions.assertThat((String)titleCollectionPropertyValue.getType()).isEqualTo((Object)"interpolation");
        Assertions.assertThat((Object)titleCollectionPropertyValue.getValue()).isEqualTo((Object)"Addresses");
        List detailsRows = (List)boc.getContainer().getRows().get(1);
        Assertions.assertThat((int)detailsRows.size()).isEqualTo(2);
        Map variables = boc.getBusinessObjectVariable();
        Assertions.assertThat((Comparable)((Variable)variables.get("customer_addresses")).getType()).isEqualTo((Object)DataType.URL);
        Assertions.assertThat((String)((String)((Variable)variables.get("customer_addresses")).getValue().get(0))).isEqualTo((Object)"{{customer_selected|lazyRef:'addresses'}}");
    }

    @Test
    public void should_generated_repeatable_container_when_contract_input_is_multiple() {
        BusinessObjectContainer boc = new BusinessObjectContainer();
        BusinessDataToWidgetMapper businessDataToWidgetMapper = this.makeBusinessDataToWidgetMapper(boc);
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.invoice.model.customer", "customer");
        node.setMultiple(true);
        node.addInput(ContractInputBuilder.aContractInput((String)"labels").withType(String.class.getName()).mulitple().build());
        LeafContractInput contractInput = (LeafContractInput)node.getInput().get(0);
        List elements = businessDataToWidgetMapper.toElement(contractInput);
        Assertions.assertThat((int)elements.size()).isEqualTo(2);
        Assertions.assertThat((String)((Component)elements.get(0)).getId()).isEqualTo((Object)"pbTitle");
        Container multipleContainer = (Container)elements.get(1);
        Assertions.assertThat((Object)((PropertyValue)multipleContainer.getPropertyValues().get("repeatedCollection")).getValue()).isEqualTo((Object)"customer_selected.labels");
    }

    private NodeBusinessObjectInput aNestedObjectInCompositionAndEager() {
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.company.model.person", "person");
        NodeBusinessObjectInput childNode = new NodeBusinessObjectInput("com.company.model.sport", "person_sport", "sport");
        childNode.addInput(ContractInputBuilder.aContractInput((String)"name").withType(String.class.getName()).build());
        childNode.addInput(ContractInputBuilder.aContractInput((String)"needBalls").withType(Boolean.class.getName()).build());
        childNode.setDataReference((DataReference)new BusinessDataReference("sport", "String", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER));
        node.addInput((ContractInput)childNode);
        return childNode;
    }

    private NodeBusinessObjectInput aNestedObjectInLazyAggregation(Boolean parentIsMultiple) {
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.invoice.model.customer", "customer");
        node.setMultiple(parentIsMultiple.booleanValue());
        NodeBusinessObjectInput childNode = new NodeBusinessObjectInput("com.invoice.model.addresses", "customer_addresses", "addresses");
        childNode.addInput(ContractInputBuilder.aContractInput((String)"addresses").withType(String.class.getName()).build());
        childNode.setDataReference((DataReference)new BusinessDataReference("addresses", "String", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.LAZY));
        node.addInput((ContractInput)childNode);
        return childNode;
    }

    private BusinessDataToWidgetMapper makeBusinessDataToWidgetMapper(BusinessObjectContainer boc) {
        return new BusinessDataToWidgetMapper(new DimensionFactory(), boc);
    }
}

