/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.util.Optional;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.migration.MigrationStep;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MigrationTest {
    @Mock
    MigrationStep<Page> migrationStep;
    Migration<Page> migration;
    Page page = PageBuilder.aPage().withId("123").build();

    @Before
    public void setUp() throws Exception {
        this.migration = new Migration("1.0.1", new MigrationStep[]{this.migrationStep});
    }

    @Test
    public void should_migrate_a_page_with_a_version_lower_than_migration() throws Exception {
        Mockito.when((Object)this.migrationStep.migrate(Mockito.any(Page.class))).thenReturn(Optional.empty());
        this.page.setDesignerVersion("1.0.0");
        this.migration.migrate((DesignerArtifact)this.page);
        ((MigrationStep)Mockito.verify(this.migrationStep)).migrate((Object)this.page);
    }

    @Test
    public void should_not_migrate_a_page_with_a_version_greater_than_migration() throws Exception {
        this.page.setDesignerVersion("1.0.2");
        this.migration.migrate((DesignerArtifact)this.page);
        ((MigrationStep)Mockito.verify(this.migrationStep, (VerificationMode)Mockito.never())).migrate((Object)this.page);
    }

    @Test
    public void should_not_migrate_a_page_with_a_version_equal_to_migration() throws Exception {
        this.page.setDesignerVersion("1.0.1");
        this.migration.migrate((DesignerArtifact)this.page);
        ((MigrationStep)Mockito.verify(this.migrationStep, (VerificationMode)Mockito.never())).migrate((Object)this.page);
    }
}

