/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.DataBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.migration.page.DataToVariableMigrationStep;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataToVariableMigrationStepTest {
    DataToVariableMigrationStep<Page> dataToVariableMigrationStep;

    @Before
    public void setUp() throws Exception {
        this.dataToVariableMigrationStep = new DataToVariableMigrationStep();
    }

    @Test
    public void should_migrate_page_with_data() throws Exception {
        Page pageWithData = PageBuilder.aPage().withId("pageWithData").withData("myData", DataBuilder.aConstantData().value("default value").build()).build();
        this.dataToVariableMigrationStep.migrate((AbstractPage)pageWithData);
        Assertions.assertThat((List)((Variable)pageWithData.getVariables().get("myData")).getValue()).isEqualTo(Arrays.asList("default value"));
        Assertions.assertThat((Map)pageWithData.getData()).isNull();
    }

    @Test
    public void should_migrate_page_with_data_with_null_value() throws Exception {
        Page pageWithData = PageBuilder.aPage().withId("pageWithData").withData("myEmptyData", DataBuilder.aConstantData().exposed(true).build()).build();
        this.dataToVariableMigrationStep.migrate((AbstractPage)pageWithData);
        Variable variable = (Variable)pageWithData.getVariables().get("myEmptyData");
        Assertions.assertThat((List)variable.getValue()).isEmpty();
        Assertions.assertThat((boolean)variable.isExposed()).isTrue();
        Assertions.assertThat((Map)pageWithData.getData()).isNull();
    }
}

