/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.rendering;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.rendering.FilesConcatenator;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FilesConcatenatorTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void should_concatenate_files() throws IOException {
        Files.write((byte[])"file1".getBytes(), (File)this.temporaryFolder.newFile("file1.js"));
        Files.write((byte[])"file2".getBytes(), (File)this.temporaryFolder.newFile("file2.js"));
        List<Path> files = Arrays.asList(this.temporaryFolder.toPath().resolve("file1.js"), this.temporaryFolder.toPath().resolve("file2.js"));
        byte[] content = FilesConcatenator.concat(files);
        Assertions.assertThat((byte[])content).isEqualTo((Object)"file1file2".getBytes());
    }
}

