/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.livebuild.PathListener;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.rendering.TemplateEngine;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.workspace.HtmlSanitizer;
import org.bonitasoft.web.designer.workspace.WidgetDirectiveBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WidgetDirectiveBuilderTest {
    @Rule
    public TemporaryFolder widgetRepositoryDirectory = new TemporaryFolder();
    @Mock
    Watcher watcher;
    @Mock
    BeanValidator validator;
    WidgetDirectiveBuilder widgetDirectiveBuilder;
    Widget pbInput;
    Widget pbButton;
    HtmlSanitizer htmlSanitizer = new HtmlSanitizer();
    TemplateEngine htmlBuilder = new TemplateEngine("widgetDirectiveTemplate.hbs.js");

    @Before
    public void setup() throws Exception {
        JacksonObjectMapper jacksonObjectMapper = new DesignerConfig().objectMapperWrapper();
        this.widgetDirectiveBuilder = new WidgetDirectiveBuilder(this.watcher, new WidgetFileBasedLoader(jacksonObjectMapper), this.htmlSanitizer);
        WidgetFileBasedLoader widgetLoader = new WidgetFileBasedLoader(jacksonObjectMapper);
        WidgetRepository repository = new WidgetRepository(Paths.get(this.widgetRepositoryDirectory.getRoot().getPath(), new String[0]), new DesignerConfig().widgetFileBasedPersister(), (JsonFileBasedLoader)widgetLoader, this.validator, (Watcher)Mockito.mock(Watcher.class));
        this.pbInput = WidgetBuilder.aWidget().id("pbInput").build();
        this.pbInput.setCustom(true);
        Files.createDirectories(repository.resolvePath(this.pbInput.getId()), new FileAttribute[0]);
        repository.updateLastUpdateAndSave((Identifiable)this.pbInput);
        this.pbButton = WidgetBuilder.aWidget().id("pbButton").build();
        this.pbButton.setCustom(true);
        Files.createDirectories(repository.resolvePath(this.pbButton.getId()), new FileAttribute[0]);
        repository.updateLastUpdateAndSave((Identifiable)this.pbButton);
    }

    @Test
    public void should_build_directives_of_a_given_directory() throws Exception {
        this.widgetDirectiveBuilder.start(this.widgetRepositoryDirectory.getRoot().toPath());
        Assertions.assertThat((String)this.readDirective("pbInput")).isEqualTo((Object)this.generateDirective(this.pbInput));
        Assertions.assertThat((String)this.readDirective("pbButton")).isEqualTo((Object)this.generateDirective(this.pbButton));
    }

    @Test
    public void should_only_build_directives_files() throws Exception {
        this.widgetRepositoryDirectory.newFile("whatever.txt");
        this.widgetDirectiveBuilder.start(this.widgetRepositoryDirectory.getRoot().toPath());
        Assertions.assertThat((Object[])this.widgetRepositoryDirectory.getRoot().list()).containsOnly((Object[])new String[]{".metadata", "pbButton", "whatever.txt", "pbInput"});
    }

    @Test
    public void should_watch_given_directory_to_build_directives_on_change() throws Exception {
        this.widgetDirectiveBuilder.start(this.widgetRepositoryDirectory.getRoot().toPath());
        ((Watcher)Mockito.verify((Object)this.watcher)).watch((Path)Matchers.eq((Object)this.widgetRepositoryDirectory.getRoot().toPath()), (PathListener)Matchers.any(PathListener.class));
    }

    @Test
    public void should_build_directive_even_if_it_already_exist() throws Exception {
        this.writeDirective("pbInput", "previous content".getBytes());
        this.widgetDirectiveBuilder.build(this.resolve("pbInput/pbInput.json"));
        Assertions.assertThat((String)this.readDirective("pbInput")).isEqualTo((Object)this.generateDirective(this.pbInput));
    }

    @Test
    public void should_exclude_metadata_from_the_build() throws Exception {
        boolean isBuildable = this.widgetDirectiveBuilder.isBuildable(".metadata/123.json");
        Assertions.assertThat((boolean)isBuildable).isFalse();
    }

    private String readDirective(String widgetId) throws IOException {
        return new String(Files.readAllBytes(this.resolve(widgetId + "/" + widgetId + ".js")));
    }

    private String generateDirective(Widget widget) throws IOException {
        return this.htmlBuilder.with("escapedTemplate", (Object)widget.getTemplate()).build((Object)widget);
    }

    private void writeDirective(String widgetId, byte[] contents) throws IOException {
        Files.write(this.resolve(widgetId + "/" + widgetId + ".js"), contents, new OpenOption[0]);
    }

    private Path resolve(String path) {
        return this.widgetRepositoryDirectory.getRoot().toPath().resolve(path);
    }
}

