/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.RowBuilder;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;

public class ContainerBuilder
extends ElementBuilder<Container> {
    private Container container = new Container();
    private String reference = "container-reference";
    private String id = "pbContainer";

    private ContainerBuilder() {
        this.container.setId(this.id);
        this.container.setReference(this.reference);
    }

    public static ContainerBuilder aContainer() {
        return new ContainerBuilder();
    }

    public ContainerBuilder with(Element ... elements) {
        return this.with(Arrays.asList(elements));
    }

    public ContainerBuilder with(List<Element> elements) {
        ArrayList<List<Element>> rows = new ArrayList<List<Element>>();
        rows.add(elements);
        this.container.setRows(rows);
        return this;
    }

    public ContainerBuilder with(ElementBuilder<?> ... elements) {
        ArrayList<Element> elem = new ArrayList<Element>();
        for (ElementBuilder<?> elementBuilder : elements) {
            elem.add((Element)elementBuilder.build());
        }
        return this.with(elem);
    }

    public ContainerBuilder with(RowBuilder ... rows) {
        ArrayList<List<Element>> containerRows = new ArrayList<List<Element>>();
        for (RowBuilder rowBuilder : rows) {
            containerRows.add(rowBuilder.build());
        }
        this.container.setRows(containerRows);
        return this;
    }

    @Override
    public Container build() {
        return this.container;
    }

    @Override
    public Container getElement() {
        return this.container;
    }
}

