/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipException;
import org.bonitasoft.web.designer.builder.ImportReportBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.controller.ImportController;
import org.bonitasoft.web.designer.controller.importer.ArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.controller.importer.ImporterResolver;
import org.bonitasoft.web.designer.controller.importer.PathImporter;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.controller.utils.Unzipper;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@RunWith(value=MockitoJUnitRunner.class)
public class ImportControllerTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private MockMvc mockMvc;
    @Mock
    private ArtifactImporter<Page> pageImporter;
    @Mock
    private ArtifactImporter<Widget> widgetImporter;
    @Mock
    private ArtifactImporter<Fragment> fragmentImporter;
    @Mock
    private PathImporter pathImporter;
    @Mock
    private Unzipper unzipper;
    @Mock
    private ImportStore importStore;
    private ImporterResolver importerResolver;
    private Path unzipedPath;

    @Before
    public void setUp() throws IOException {
        this.importerResolver = (ImporterResolver)Mockito.spy((Object)new ImporterResolver(new DesignerConfig().artifactImporters(this.pageImporter, this.widgetImporter, this.fragmentImporter)));
        ImportController importController = new ImportController(this.pathImporter, this.importerResolver, this.importStore, this.unzipper);
        this.unzipedPath = this.tempDir.newFolderPath("unzipedPath");
        Mockito.when((Object)this.unzipper.unzipInTempDir((InputStream)Matchers.any(InputStream.class), Matchers.anyString())).thenReturn((Object)this.unzipedPath);
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(importController).build();
    }

    @Test
    public void should_respond_404_for_an_unknown_artifact_type() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/unknown", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_import_a_file_with_zip_content_type() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(this.aFile("application/zip"))).andExpect(MockMvcResultMatchers.status().isCreated());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(this.aFile("application/x-zip-compressed"))).andExpect(MockMvcResultMatchers.status().isCreated());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(this.aFile("application/x-zip"))).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    private MockMultipartFile aFile(String contentType) {
        return new MockMultipartFile("file", "myfile.zip", contentType, "foo".getBytes());
    }

    @Test
    public void should_respond_400_when_file_content_type_is_not_supported() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "text/html", "foo".getBytes());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"IllegalArgumentException")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Only zip files are allowed when importing a component"));
    }

    @Test
    public void should_import_a_file_with_octetstream_content_type() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(this.aFile("application/octet-stream"))).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void should_respond_400_when_file_content_type_is_octetstream_but_filename_is_not_a_zip() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.png", "application/octet-stream", "foo".getBytes());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"IllegalArgumentException")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Only zip files are allowed when importing a component"));
    }

    @Test
    public void should_respond_400_when_file_content_is_empty() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "".getBytes());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"IllegalArgumentException")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Part named [file] is needed to successfully import a component"));
    }

    @Test
    public void should_import_a_page_with_its_dependencies() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(PageBuilder.aPage().withId("aPage").withName("thePage")).withUUID("UUIDZipFile").withStatus(ImportReport.Status.CONFLICT).withAdded(WidgetBuilder.aWidget().id("addedWidget").name("newWidget")).withOverwritten(WidgetBuilder.aWidget().id("overwrittenWidget").name("oldWidget")).build();
        Mockito.when((Object)this.pathImporter.importFromPath(this.unzipedPath, this.pageImporter)).thenReturn((Object)expectedReport);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"uuid", (Object[])new Object[0]).value((Object)"UUIDZipFile")).andExpect(MockMvcResultMatchers.jsonPath((String)"extractedDirName", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"element.id", (Object[])new Object[0]).value((Object)"aPage")).andExpect(MockMvcResultMatchers.jsonPath((String)"status", (Object[])new Object[0]).value((Object)"conflict")).andExpect(MockMvcResultMatchers.jsonPath((String)"element.name", (Object[])new Object[0]).value((Object)"thePage")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.added.widget[0].id", (Object[])new Object[0]).value((Object)"addedWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.added.widget[0].name", (Object[])new Object[0]).value((Object)"newWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.overwritten.widget[0].id", (Object[])new Object[0]).value((Object)"overwrittenWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.overwritten.widget[0].name", (Object[])new Object[0]).value((Object)"oldWidget"));
    }

    @Test
    public void should_force_a_page_import() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(PageBuilder.aPage().withId("aPage").withName("thePage")).withUUID("UUIDZipFile").withStatus(ImportReport.Status.IMPORTED).withAdded(WidgetBuilder.aWidget().id("addedWidget").name("newWidget")).withOverwritten(WidgetBuilder.aWidget().id("overwrittenWidget").name("oldWidget")).build();
        Mockito.when((Object)this.pathImporter.forceImportFromPath(this.unzipedPath, this.pageImporter)).thenReturn((Object)expectedReport);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page?force=true", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"uuid", (Object[])new Object[0]).value((Object)"UUIDZipFile")).andExpect(MockMvcResultMatchers.jsonPath((String)"extractedDirName", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"element.id", (Object[])new Object[0]).value((Object)"aPage")).andExpect(MockMvcResultMatchers.jsonPath((String)"status", (Object[])new Object[0]).value((Object)"imported")).andExpect(MockMvcResultMatchers.jsonPath((String)"element.name", (Object[])new Object[0]).value((Object)"thePage")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.added.widget[0].id", (Object[])new Object[0]).value((Object)"addedWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.added.widget[0].name", (Object[])new Object[0]).value((Object)"newWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.overwritten.widget[0].id", (Object[])new Object[0]).value((Object)"overwrittenWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.overwritten.widget[0].name", (Object[])new Object[0]).value((Object)"oldWidget"));
    }

    @Test
    public void should_respond_an_error_with_ok_code_when_import_exception_occurs_while_importing_a_page() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        Mockito.when((Object)this.pathImporter.importFromPath(this.unzipedPath, this.pageImporter)).thenThrow(new Throwable[]{new ImportException(ImportException.Type.SERVER_ERROR, "an error messge")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"SERVER_ERROR")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"an error messge"));
    }

    @Test
    public void should_import_a_widget() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(WidgetBuilder.aWidget().id("aWidget").name("myWidgetName")).build();
        Mockito.when((Object)this.pathImporter.importFromPath(this.unzipedPath, this.widgetImporter)).thenReturn((Object)expectedReport);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/widget", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"element.id", (Object[])new Object[0]).value((Object)"aWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"element.name", (Object[])new Object[0]).value((Object)"myWidgetName"));
    }

    @Test
    public void should_force_a_widget_import() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(WidgetBuilder.aWidget().id("aWidget").name("myWidgetName")).build();
        Mockito.when((Object)this.pathImporter.forceImportFromPath(this.unzipedPath, this.widgetImporter)).thenReturn((Object)expectedReport);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/widget?force=true", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"element.id", (Object[])new Object[0]).value((Object)"aWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"element.name", (Object[])new Object[0]).value((Object)"myWidgetName"));
    }

    @Test
    public void should_force_an_uncompleted_import() throws Exception {
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(WidgetBuilder.aWidget().id("aWidget").name("myWidgetName")).build();
        Path aPath = Paths.get("widget/import/path", new String[0]);
        Import t = new Import(this.widgetImporter, "import-uuid", aPath);
        Mockito.when((Object)this.importStore.get("import-uuid")).thenReturn((Object)t);
        Mockito.when((Object)this.widgetImporter.forceImport((Import)Matchers.any(Import.class))).thenReturn((Object)expectedReport);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/import/import-uuid/force", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"element.id", (Object[])new Object[0]).value((Object)"aWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"element.name", (Object[])new Object[0]).value((Object)"myWidgetName"));
    }

    @Test
    public void should_cancel_an_import() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/import/import-uuid/cancel", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        ((ImportStore)Mockito.verify((Object)this.importStore)).remove("import-uuid");
    }

    @Test
    public void should_respond_an_error_with_ok_code_when_import_exception_occurs_while_importing_a_widget() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        Mockito.when((Object)this.pathImporter.importFromPath(this.unzipedPath, this.widgetImporter)).thenThrow(new Throwable[]{new ImportException(ImportException.Type.SERVER_ERROR, "an error messge")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/widget", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"SERVER_ERROR")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"an error messge"));
    }

    @Test
    public void should_respond_an_error_with_ok_code_when_import_exception_occurs_while_zip_file_could_not_be_opened() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        Mockito.when((Object)this.unzipper.unzipInTempDir((InputStream)Matchers.any(InputStream.class), Matchers.anyString())).thenThrow(new Class[]{ZipException.class});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/widget", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"CANNOT_OPEN_ZIP")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Cannot open zip file"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"CANNOT_OPEN_ZIP")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Cannot open zip file"));
    }

    @Test
    public void should_respond_an_error_with_ok_code_when_import_exception_occurs_while_unzipping() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        Mockito.when((Object)this.unzipper.unzipInTempDir((InputStream)Matchers.any(InputStream.class), Matchers.anyString())).thenThrow(new Class[]{IOException.class});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/widget", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"SERVER_ERROR")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Error while unzipping zip file"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/page", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"SERVER_ERROR")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Error while unzipping zip file"));
    }

    @Test
    public void should_import_an_artifact() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(WidgetBuilder.aWidget().id("aWidget").name("myWidgetName")).build();
        ((ImporterResolver)Mockito.doReturn(this.widgetImporter).when((Object)this.importerResolver)).getImporter(this.unzipedPath);
        Mockito.when((Object)this.pathImporter.importFromPath(this.unzipedPath, this.widgetImporter)).thenReturn((Object)expectedReport);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/artifact", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"element.id", (Object[])new Object[0]).value((Object)"aWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"element.name", (Object[])new Object[0]).value((Object)"myWidgetName"));
    }

    @Test
    public void should_respond_an_error_with_ok_code_when_model_file_is_not_found_while_importing_an_artifact() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        Files.createDirectory(this.unzipedPath.resolve("resources"), new FileAttribute[0]);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/artifact", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"MODEL_NOT_FOUND")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"Could not load component, artifact model file not found")).andExpect(MockMvcResultMatchers.jsonPath((String)"infos.modelfiles", (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new String[]{"page.json", "widget.json", "fragment.json"})));
    }

    @Test
    public void should_import_a_fragment() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(PageBuilder.aPage().withId("aPage").withName("thePage")).withUUID("UUIDZipFile").withAdded(WidgetBuilder.aWidget().id("addedWidget").name("newWidget")).withOverwritten(WidgetBuilder.aWidget().id("overwrittenWidget").name("oldWidget")).build();
        Mockito.when((Object)this.pathImporter.importFromPath(this.unzipedPath, this.fragmentImporter)).thenReturn((Object)expectedReport);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/fragment", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"uuid", (Object[])new Object[0]).value((Object)"UUIDZipFile")).andExpect(MockMvcResultMatchers.jsonPath((String)"extractedDirName", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"element.id", (Object[])new Object[0]).value((Object)"aPage")).andExpect(MockMvcResultMatchers.jsonPath((String)"element.name", (Object[])new Object[0]).value((Object)"thePage")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.added.widget[0].id", (Object[])new Object[0]).value((Object)"addedWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.added.widget[0].name", (Object[])new Object[0]).value((Object)"newWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.overwritten.widget[0].id", (Object[])new Object[0]).value((Object)"overwrittenWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.overwritten.widget[0].name", (Object[])new Object[0]).value((Object)"oldWidget"));
    }

    @Test
    public void should_force_a_fragment_import() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(PageBuilder.aPage().withId("aPage").withName("thePage")).withUUID("UUIDZipFile").withAdded(WidgetBuilder.aWidget().id("addedWidget").name("newWidget")).withOverwritten(WidgetBuilder.aWidget().id("overwrittenWidget").name("oldWidget")).build();
        Mockito.when((Object)this.pathImporter.forceImportFromPath(this.unzipedPath, this.fragmentImporter)).thenReturn((Object)expectedReport);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/fragment?force=true", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"uuid", (Object[])new Object[0]).value((Object)"UUIDZipFile")).andExpect(MockMvcResultMatchers.jsonPath((String)"extractedDirName", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"element.id", (Object[])new Object[0]).value((Object)"aPage")).andExpect(MockMvcResultMatchers.jsonPath((String)"element.name", (Object[])new Object[0]).value((Object)"thePage")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.added.widget[0].id", (Object[])new Object[0]).value((Object)"addedWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.added.widget[0].name", (Object[])new Object[0]).value((Object)"newWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.overwritten.widget[0].id", (Object[])new Object[0]).value((Object)"overwrittenWidget")).andExpect(MockMvcResultMatchers.jsonPath((String)"dependencies.overwritten.widget[0].name", (Object[])new Object[0]).value((Object)"oldWidget"));
    }

    @Test
    public void should_cancel_a_fragment_import() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/import/import-uuid/cancel", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        ((ImportStore)Mockito.verify((Object)this.importStore)).remove("import-uuid");
    }

    @Test
    public void should_respond_an_error_with_ok_code_when_import_exception_occurs_while_importing_a_fragment() throws Exception {
        MockMultipartFile file = new MockMultipartFile("file", "myfile.zip", "application/zip", "foo".getBytes());
        Mockito.when((Object)this.pathImporter.importFromPath(this.unzipedPath, this.fragmentImporter)).thenThrow(new Throwable[]{new ImportException(ImportException.Type.SERVER_ERROR, "an error message")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/import/fragment", (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Object[])new Object[0]).value((Object)"SERVER_ERROR")).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Object[])new Object[0]).value((Object)"an error message"));
    }
}

