/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.controller.export.properties.ConstantPropertyValuePredicate;
import org.bonitasoft.web.designer.model.page.Component;
import org.junit.Test;

public class ConstantPropertyValuePredicateTest {
    @Test
    public void should_return_true_when_the_property_value_matches() throws Exception {
        ConstantPropertyValuePredicate predicate = new ConstantPropertyValuePredicate((Object)"bar");
        Assertions.assertThat((boolean)predicate.apply((Component)ComponentBuilder.aComponent().withPropertyValue("foo", "constant", "bar").build())).isTrue();
    }

    @Test
    public void should_return_false_when_property_value_do_not_match() throws Exception {
        ConstantPropertyValuePredicate predicate = new ConstantPropertyValuePredicate((Object)"qux");
        Assertions.assertThat((boolean)predicate.apply((Component)ComponentBuilder.aComponent().withPropertyValue("foo", "constant", "bar").build())).isFalse();
    }

    @Test
    public void should_return_false_when_property_value_is_not_a_constant() throws Exception {
        ConstantPropertyValuePredicate predicate = new ConstantPropertyValuePredicate((Object)"bar");
        Assertions.assertThat((boolean)predicate.apply((Component)ComponentBuilder.aComponent().withPropertyValue("foo", "whatever", "bar").build())).isFalse();
    }
}

