/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.controller.export.properties.WidgetPropertiesBuilder;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class WidgetPropertiesBuilderTest {
    private static final String DESIGNER_VERSION = "1.12.1";
    @InjectMocks
    private WidgetPropertiesBuilder widgetPropertiesBuilder;
    private Widget widget;

    @Before
    public void setUp() throws Exception {
        this.widget = new Widget();
        this.widget.setName("myWidget");
    }

    @Test
    public void should_build_a_well_formed_page_property_file() throws Exception {
        this.widget.setDesignerVersion(DESIGNER_VERSION);
        ReflectionTestUtils.setField((Object)this.widgetPropertiesBuilder, (String)"uidVersion", (Object)DESIGNER_VERSION);
        byte[] a = this.widgetPropertiesBuilder.build(this.widget);
        String properties = new String(a);
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"contentType=widget"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"name=myWidget"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"designerVersion=1.12.1"});
    }
}

