/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.FragmentImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.WidgetImporter;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ImportReportTest {
    @Mock
    private WidgetImporter widgetImporter;
    @Mock
    private FragmentImporter fragmentImporter;
    @Mock
    private AssetImporter assetImporter;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.widgetImporter.getComponentName()).thenReturn((Object)"widget");
        Mockito.when((Object)this.fragmentImporter.getComponentName()).thenReturn((Object)"fragment");
    }

    private Widget existing(Widget widget) {
        Mockito.when((Object)this.widgetImporter.getOriginalElementFromRepository((Identifiable)widget)).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetImporter.exists((Identifiable)widget)).thenReturn((Object)true);
        return widget;
    }

    @Test
    public void should_report_imported_element_when_it_is_a_page() throws Exception {
        Page importedPage = PageBuilder.aPage().build();
        ImportReport report = ImportReport.from((Identifiable)importedPage, new HashMap());
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)importedPage);
    }

    @Test
    public void should_report_imported_element_when_it_is_a_widget() throws Exception {
        Widget importedWidget = WidgetBuilder.aWidget().build();
        ImportReport report = ImportReport.from((Identifiable)importedWidget, new HashMap());
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)importedWidget);
    }

    @Test
    public void should_include_added_and_overriden_widget_in_imported_dependencies() throws Exception {
        Widget existingWidget = this.existing(WidgetBuilder.aWidget().id("existing").build());
        Widget newWidget = WidgetBuilder.aWidget().id("newOne").build();
        HashMap<WidgetImporter, List<Widget>> dependencies = new HashMap<WidgetImporter, List<Widget>>();
        dependencies.put(this.widgetImporter, Arrays.asList(newWidget, existingWidget));
        ImportReport report = ImportReport.from((Identifiable)PageBuilder.aPage().build(), dependencies);
        Assertions.assertThat((List)((List)report.getDependencies().getAdded().get("widget"))).containsOnly(new Object[]{newWidget});
        Assertions.assertThat((List)((List)report.getDependencies().getOverwritten().get("widget"))).containsOnly(new Object[]{existingWidget});
    }

    @Test
    public void should_not_include_assets_in_imported_dependencies() throws Exception {
        HashMap<AssetImporter, List<Asset>> dependencies = new HashMap<AssetImporter, List<Asset>>();
        dependencies.put(this.assetImporter, Arrays.asList(AssetBuilder.anAsset().build()));
        ImportReport report = ImportReport.from((Identifiable)PageBuilder.aPage().build(), dependencies);
        Assertions.assertThat((Map)report.getDependencies().getAdded()).isNull();
        Assertions.assertThat((Map)report.getDependencies().getOverwritten()).isNull();
    }

    private Fragment mockExistsInRepository(Fragment fragment) {
        Mockito.when((Object)this.fragmentImporter.exists((Identifiable)fragment)).thenReturn((Object)true);
        Mockito.when((Object)this.fragmentImporter.getOriginalElementFromRepository((Identifiable)fragment)).thenReturn((Object)fragment);
        return fragment;
    }

    private Widget mockExistsInRepository(Widget widget) {
        Mockito.when((Object)this.widgetImporter.exists((Identifiable)widget)).thenReturn((Object)true);
        Mockito.when((Object)this.widgetImporter.getOriginalElementFromRepository((Identifiable)widget)).thenReturn((Object)widget);
        return widget;
    }

    @Test
    public void should_report_imported_element_when_it_is_a_fragment() throws Exception {
        Fragment importedFragment = FragmentBuilder.aFragment().build();
        ImportReport report = ImportReport.from((Identifiable)importedFragment, new HashMap());
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)importedFragment);
    }

    @Test
    public void should_include_added_and_overwritten_widget_in_imported_dependencies() throws Exception {
        Widget newWidget = WidgetBuilder.aWidget().id("newOne").build();
        Widget existingWidget = this.mockExistsInRepository(WidgetBuilder.aWidget().id("existing").build());
        HashMap<WidgetImporter, List<Widget>> dependencies = new HashMap<WidgetImporter, List<Widget>>();
        dependencies.put(this.widgetImporter, Arrays.asList(newWidget, existingWidget));
        ImportReport report = ImportReport.from((Identifiable)FragmentBuilder.aFragment().build(), dependencies);
        Assertions.assertThat((List)((List)report.getDependencies().getAdded().get("widget"))).containsOnly(new Object[]{newWidget});
        Assertions.assertThat((List)((List)report.getDependencies().getOverwritten().get("widget"))).containsOnly(new Object[]{existingWidget});
    }

    @Test
    public void should_include_added_and_overwritten_fragments_in_imported_dependencies() throws Exception {
        Fragment newFragment = FragmentBuilder.aFragment().id("newOne").build();
        Fragment existingFragment = this.mockExistsInRepository(FragmentBuilder.aFragment().id("existing").build());
        HashMap<FragmentImporter, List<Fragment>> dependencies = new HashMap<FragmentImporter, List<Fragment>>();
        dependencies.put(this.fragmentImporter, Arrays.asList(newFragment, existingFragment));
        ImportReport report = ImportReport.from((Identifiable)FragmentBuilder.aFragment().build(), dependencies);
        Assertions.assertThat((List)((List)report.getDependencies().getAdded().get("fragment"))).containsOnly(new Object[]{newFragment});
        Assertions.assertThat((List)((List)report.getDependencies().getOverwritten().get("fragment"))).containsOnly(new Object[]{existingFragment});
    }
}

