/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping.dataManagement;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.generator.mapping.DimensionFactory;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.BusinessDataToWidgetMapper;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.BusinessObjectContainer;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.BusinessObjectVisitorImpl;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.NodeBusinessObjectInput;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ParameterType;
import org.bonitasoft.web.designer.model.ElementContainer;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.ContractInputVisitor;
import org.bonitasoft.web.designer.model.contract.DataReference;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.junit.Before;
import org.junit.Test;

public class BusinessObjectVisitorImplTest {
    private BusinessDataToWidgetMapper businessDataToWidgetMapper;

    @Before
    public void setUp() throws Exception {
        this.businessDataToWidgetMapper = new BusinessDataToWidgetMapper(new DimensionFactory(), new BusinessObjectContainer(new Container()));
    }

    @Test
    public void add_master_details_ui_when_visit_a_node_business_object() throws Exception {
        Container initContainer = new Container();
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.company.model.person");
        node.setPageDataName("Person");
        node.addInput((ContractInput)new LeafContractInput("name", String.class));
        BusinessObjectVisitorImpl visitor = new BusinessObjectVisitorImpl((ElementContainer)initContainer, this.businessDataToWidgetMapper);
        node.accept((ContractInputVisitor)visitor);
        Container container = (Container)((List)initContainer.getRows().get(0)).get(0);
        Assertions.assertThat((List)container.getRows()).hasSize(3);
        List tableRow = (List)container.getRows().get(1);
        Component pbTable = (Component)tableRow.get(0);
        Assertions.assertThat(tableRow.get(0)).isInstanceOf(Component.class);
        Assertions.assertThat((String)pbTable.getId()).isEqualTo((Object)"pbTable");
        Assertions.assertThat((Object)((PropertyValue)pbTable.getPropertyValues().get("content")).getValue()).isEqualTo((Object)"Person");
        Assertions.assertThat((String)((PropertyValue)pbTable.getPropertyValues().get("content")).getType()).isEqualTo((Object)ParameterType.EXPRESSION.getValue());
        List detailsRow = (List)container.getRows().get(2);
        Component component = (Component)detailsRow.get(0);
        Assertions.assertThat(detailsRow.get(0)).isInstanceOf(Component.class);
        Assertions.assertThat((String)component.getId()).isEqualTo((Object)"pbContainer");
        Assertions.assertThat((Integer)((Integer)component.getDimension().get("xs"))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)((Component)detailsRow.get(1)).getDimension().get("xs"))).isEqualTo(11);
    }

    @Test
    public void add_master_details_pattern_when_visit_a_child_node_business_object() throws Exception {
        Container container = new Container();
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.company.model.person", "person");
        node.setMultiple(true);
        node.addInput((ContractInput)new LeafContractInput("name", String.class));
        NodeBusinessObjectInput childNode = new NodeBusinessObjectInput("com.company.model.addresses", "person_address", "address");
        childNode.setMultiple(true);
        LeafContractInput a = new LeafContractInput("city", String.class);
        childNode.setDataReference((DataReference)new BusinessDataReference("addresses", "String", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.LAZY));
        childNode.addInput((ContractInput)a);
        node.addInput((ContractInput)childNode);
        BusinessObjectVisitorImpl visitor = new BusinessObjectVisitorImpl((ElementContainer)container, this.businessDataToWidgetMapper);
        node.accept((ContractInputVisitor)visitor);
        Container objectContainer = (Container)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((List)objectContainer.getRows()).hasSize(3);
        List rows = objectContainer.getRows();
        Assertions.assertThat((Object)((PropertyValue)((Component)((List)rows.get(0)).get(0)).getPropertyValues().get("text")).getValue()).isEqualTo((Object)"Person");
        Assertions.assertThat((String)((Component)((List)rows.get(1)).get(0)).getId()).isEqualTo((Object)"pbTable");
        Assertions.assertThat((Object)((PropertyValue)((Component)((List)rows.get(1)).get(0)).getPropertyValues().get("headers")).getValue()).isEqualTo(Arrays.asList("Name"));
        Container detailsContainer = (Container)((List)rows.get(2)).get(1);
        Assertions.assertThat((String)detailsContainer.getId()).isEqualTo((Object)"pbContainer");
        Assertions.assertThat((Integer)((Integer)detailsContainer.getDimension().get("xs"))).isEqualTo(11);
        Assertions.assertThat((Object)((PropertyValue)detailsContainer.getPropertyValues().get("hidden")).getValue()).isEqualTo((Object)"!person_selected");
        Assertions.assertThat((Object)((PropertyValue)((Component)((List)detailsContainer.getRows().get(0)).get(0)).getPropertyValues().get("label")).getValue()).isEqualTo((Object)"Name");
        List addressesContainerObject = ((Container)((List)detailsContainer.getRows().get(1)).get(0)).getRows();
        Assertions.assertThat((int)addressesContainerObject.size()).isEqualTo(3);
        Assertions.assertThat((Object)((PropertyValue)((Component)((List)addressesContainerObject.get(0)).get(0)).getPropertyValues().get("text")).getValue()).isEqualTo((Object)"Addresses");
        Assertions.assertThat((Object)((PropertyValue)((Component)((List)addressesContainerObject.get(1)).get(0)).getPropertyValues().get("content")).getValue()).isEqualTo((Object)"person_address");
        Assertions.assertThat((Object)((PropertyValue)((Component)((List)addressesContainerObject.get(1)).get(0)).getPropertyValues().get("selectedRow")).getValue()).isEqualTo((Object)"person_address_selected");
    }

    @Test
    public void visit_business_object_with_nested_object() throws Exception {
        Container container = new Container();
        NodeBusinessObjectInput person = this.aComplexNodeObjectInput();
        BusinessObjectVisitorImpl visitor = new BusinessObjectVisitorImpl((ElementContainer)container, this.businessDataToWidgetMapper);
        person.accept((ContractInputVisitor)visitor);
        Container rootContainer = (Container)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((List)rootContainer.getRows()).hasSize(3);
        Container detailsContainer = (Container)((List)rootContainer.getRows().get(2)).get(1);
        Assertions.assertThat((List)detailsContainer.getRows()).hasSize(3);
        Assertions.assertThat((String)detailsContainer.getDescription()).isNotEmpty();
    }

    @Test
    public void visit_business_object_with_complex_object() {
        Container container = new Container();
        NodeBusinessObjectInput invoice = this.aInvoiceInvoiceLineProductInCompositionAndEager();
        BusinessObjectVisitorImpl visitor = new BusinessObjectVisitorImpl((ElementContainer)container, this.businessDataToWidgetMapper);
        invoice.accept((ContractInputVisitor)visitor);
        Container rootContainer = (Container)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((List)rootContainer.getRows()).hasSize(3);
        Container invoiceDetailsContainer = (Container)((List)rootContainer.getRows().get(2)).get(1);
        Assertions.assertThat((List)invoiceDetailsContainer.getRows()).hasSize(2);
        Assertions.assertThat((String)invoiceDetailsContainer.getDescription()).isNotEmpty();
        Container invoiceLineDetailsContainer = (Container)((List)((Container)((List)invoiceDetailsContainer.getRows().get(1)).get(0)).getRows().get(2)).get(1);
        Assertions.assertThat((List)invoiceLineDetailsContainer.getRows()).hasSize(3);
        Component quantity = (Component)((List)invoiceLineDetailsContainer.getRows().get(1)).get(0);
        Assertions.assertThat((Object)((PropertyValue)quantity.getPropertyValues().get("value")).getValue()).isEqualTo((Object)"invoice_invoiceLines_selected.price");
        Component price = (Component)((List)invoiceLineDetailsContainer.getRows().get(1)).get(0);
        Assertions.assertThat((Object)((PropertyValue)price.getPropertyValues().get("value")).getValue()).isEqualTo((Object)"invoice_invoiceLines_selected.price");
        Container productDetailsContainer = (Container)((List)((Container)((List)invoiceLineDetailsContainer.getRows().get(2)).get(0)).getRows().get(1)).get(1);
        Assertions.assertThat((List)productDetailsContainer.getRows()).hasSize(2);
        Component productNameInput = (Component)((List)productDetailsContainer.getRows().get(0)).get(0);
        Assertions.assertThat((Object)((PropertyValue)productNameInput.getPropertyValues().get("value")).getValue()).isEqualTo((Object)"invoice_invoiceLines_selected.product.name");
    }

    @Test
    public void should_no_generated_container_for_business_object_relation_when_it_dont_have_attribute() {
        Container container = new Container();
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.company.model.customer");
        node.setPageDataName("Customer");
        node.addInput((ContractInput)new LeafContractInput("name", String.class));
        NodeBusinessObjectInput childNode = new NodeBusinessObjectInput("com.company.model.adress", "adress", "adress");
        childNode.setDataReference((DataReference)new BusinessDataReference("customer_adress", "String", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.LAZY));
        node.addInput((ContractInput)childNode);
        BusinessObjectVisitorImpl visitor = new BusinessObjectVisitorImpl((ElementContainer)container, this.businessDataToWidgetMapper);
        node.accept((ContractInputVisitor)visitor);
        Container rootContainer = (Container)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((List)rootContainer.getRows()).hasSize(3);
        Container detailsContainer = (Container)((List)rootContainer.getRows().get(2)).get(1);
        Assertions.assertThat((List)detailsContainer.getRows()).hasSize(1);
        Assertions.assertThat((String)detailsContainer.getDescription()).isNotEmpty();
    }

    private NodeBusinessObjectInput aInvoiceInvoiceLineProductInCompositionAndEager() {
        NodeBusinessObjectInput node = new NodeBusinessObjectInput("com.company.model.invoice", "invoice");
        node.addInput((ContractInput)new LeafContractInput("date", String.class));
        node.setMultiple(true);
        NodeBusinessObjectInput childNode = new NodeBusinessObjectInput("com.company.model.invoiceLine", "invoice_invoiceLines", "invoiceLine");
        childNode.addInput(ContractInputBuilder.aContractInput((String)"quantity").withType(Integer.class.getName()).build());
        childNode.addInput(ContractInputBuilder.aContractInput((String)"price").withType(Integer.class.getName()).build());
        childNode.setDataReference((DataReference)new BusinessDataReference("invoice_invoiceLines", "String", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER));
        childNode.setMultiple(true);
        node.addInput((ContractInput)childNode);
        NodeBusinessObjectInput product = new NodeBusinessObjectInput("com.company.model.product", "invoice_invoiceLines", "product");
        product.addInput(ContractInputBuilder.aContractInput((String)"name").withType(String.class.getName()).build());
        product.addInput(ContractInputBuilder.aContractInput((String)"labels").mulitple().withType(String.class.getName()).build());
        product.setDataReference((DataReference)new BusinessDataReference("invoice_invoiceLines", "String", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.EAGER));
        childNode.addInput((ContractInput)product);
        return node;
    }

    private NodeBusinessObjectInput aComplexNodeObjectInput() {
        NodeBusinessObjectInput person = new NodeBusinessObjectInput("com.company.model.person");
        person.setPageDataName("person");
        person.setMultiple(true);
        person.addInput((ContractInput)new LeafContractInput("name", String.class));
        person.addInput((ContractInput)new LeafContractInput("lastName", String.class));
        NodeBusinessObjectInput address = new NodeBusinessObjectInput("com.company.model.address", "person_address", "address");
        address.addInput((ContractInput)new LeafContractInput("city", String.class));
        address.addInput((ContractInput)new LeafContractInput("zipCode", Integer.class));
        address.setDataReference((DataReference)new BusinessDataReference("address", "String", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER));
        person.addInput((ContractInput)address);
        NodeBusinessObjectInput sport = new NodeBusinessObjectInput("com.company.model.sport", "person_sport", "sport");
        sport.addInput((ContractInput)new LeafContractInput("Name", String.class));
        sport.addInput((ContractInput)new LeafContractInput("needBalls", Boolean.class));
        LeafContractInput comments = new LeafContractInput("comments", Boolean.class);
        comments.setMultiple(true);
        sport.addInput((ContractInput)comments);
        sport.setPageDataName("sport");
        sport.setDataReference((DataReference)new BusinessDataReference("sport", "String", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.LAZY));
        return person;
    }
}

