/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.livebuild;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.awaitility.Awaitility;
import org.bonitasoft.web.designer.livebuild.ObserverFactory;
import org.bonitasoft.web.designer.livebuild.PathListener;
import org.bonitasoft.web.designer.livebuild.PathListenerStub;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class WatcherTest {
    private static final long POLLING_DELAY = 10L;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static FileAlterationMonitor monitor = new FileAlterationMonitor(10L);
    private Watcher watcher;
    private Path subDirectory;

    @BeforeClass
    public static void startMonitor() throws Exception {
        monitor.start();
    }

    @AfterClass
    public static void stopMonitor() throws Exception {
        monitor.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.subDirectory = Files.createDirectory(this.folder.toPath().resolve("un r\u00e9pertoire"), new FileAttribute[0]);
        this.watcher = new Watcher(new ObserverFactory(), monitor);
    }

    @Test
    public void should_trigger_a_created_event_when_a_file_is_created() throws Exception {
        PathListenerStub listener = new PathListenerStub();
        this.watcher.watch(this.folder.toPath(), (PathListener)listener);
        Path file = Files.createFile(this.subDirectory.resolve("file"), new FileAttribute[0]);
        Awaitility.await().until(this.changedFilesContainsExactly(listener, file));
    }

    @Test
    public void should_trigger_a_modified_event_when_a_file_is_modified() throws Exception {
        Path existingFile = Files.createFile(this.subDirectory.resolve("file"), new FileAttribute[0]);
        PathListenerStub listener = new PathListenerStub();
        this.watcher.watch(this.folder.toPath(), (PathListener)listener);
        Files.write(existingFile, "hello".getBytes(), StandardOpenOption.APPEND);
        Awaitility.await().until(this.changedFilesContainsExactly(listener, existingFile));
    }

    private Callable<Boolean> changedFilesContainsExactly(final PathListenerStub listener, final Path expectedFile) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Set<Path> changed = listener.getChanged();
                return changed.size() == 1 && changed.contains(expectedFile);
            }
        };
    }
}

