/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.localization;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.localization.LocalizationFactory;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LocalizationFactoryTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Mock
    PageRepository pageRepository;
    @InjectMocks
    LocalizationFactory localizationFactory;
    String localizationFileContent = "{\"fr-FR\":{\"Hello\":\"Bonjour\"}}";
    Page page = PageBuilder.aPage().withId("page").build();
    File localizationFile;

    @Before
    public void setUp() throws Exception {
        File pageFolder = this.temporaryFolder.newFolder("page");
        this.temporaryFolder.newFolder(new String[]{"page", "assets", "json"});
        this.localizationFile = this.temporaryFolder.newFile("page/assets/json/localization.json");
        Mockito.when((Object)this.pageRepository.resolvePath("page")).thenReturn((Object)pageFolder.toPath());
    }

    @Test
    public void should_create_a_factory_which_contains_localizations() throws Exception {
        FileUtils.writeByteArrayToFile((File)this.localizationFile, (byte[])this.localizationFileContent.getBytes());
        Assertions.assertThat((String)this.localizationFactory.generate((Previewable)this.page)).isEqualTo((Object)this.createFactory(this.localizationFileContent));
    }

    @Test
    public void should_create_an_empty_factory_whenever_localization_file_is_not_valid_json() throws Exception {
        FileUtils.writeByteArrayToFile((File)this.localizationFile, (byte[])"invalid json".getBytes());
        Assertions.assertThat((String)this.localizationFactory.generate((Previewable)this.page)).isEqualTo((Object)this.createFactory("{}"));
    }

    @Test
    public void should_create_an_empty_factory_whenever_localization_file_does_not_exist() throws Exception {
        FileUtils.deleteQuietly((File)this.localizationFile);
        Assertions.assertThat((String)this.localizationFactory.generate((Previewable)this.page)).isEqualTo((Object)this.createFactory("{}"));
    }

    @Test
    public void should_create_an_empty_string_for_fragments() throws Exception {
        Assertions.assertThat((String)this.localizationFactory.generate((Previewable)FragmentBuilder.aFragment().build())).isEqualTo((Object)("angular.module('bonitasoft.ui.services').factory('localizationFactory', function() {" + System.lineSeparator() + "  return {" + System.lineSeparator() + "    get: function() {" + System.lineSeparator() + "      return {};" + System.lineSeparator() + "    }" + System.lineSeparator() + "  };" + System.lineSeparator() + "});" + System.lineSeparator()));
    }

    private String createFactory(String content) {
        return String.format("angular.module('bonitasoft.ui.services').factory('localizationFactory', function() {" + System.lineSeparator() + "  return {" + System.lineSeparator() + "    get: function() {" + System.lineSeparator() + "      return %s;" + System.lineSeparator() + "    }" + System.lineSeparator() + "  };" + System.lineSeparator() + "});" + System.lineSeparator(), content);
    }
}

