/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.migration.AssetIdMigrationStep;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.Test;

public class AssetIdMigrationStepTest {
    @Test
    public void should_migrate_artifact_assets() throws Exception {
        AssetIdMigrationStep migrationStep = new AssetIdMigrationStep();
        Page page = PageBuilder.aPage().withAsset(AssetBuilder.anAsset().withId(null)).build();
        migrationStep.migrate((Identifiable)page);
        Assertions.assertThat((String)((Asset)page.getAssets().iterator().next()).getId()).isNotNull();
    }

    @Test
    public void should_not_change_an_asset_id() throws Exception {
        AssetIdMigrationStep migrationStep = new AssetIdMigrationStep();
        Page page = PageBuilder.aPage().withAsset(AssetBuilder.anAsset().withId("123")).build();
        migrationStep.migrate((Identifiable)page);
        Assertions.assertThat((String)((Asset)page.getAssets().iterator().next()).getId()).isEqualTo((Object)"123");
    }
}

