/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.junit.Test;

public class ProvidedWidgetsModelTest {
    @Test
    public void provided_widgets_should_be_deserializable() throws Exception {
        URI widgets = this.getClass().getResource("/widgets").toURI();
        Files.walkFileTree(Paths.get(widgets), new IsWidgetDeserializableVisitor());
    }

    private final class IsWidgetDeserializableVisitor
    extends SimpleFileVisitor<Path> {
        private final JacksonObjectMapper objectMapper = new DesignerConfig().objectMapperWrapper();

        private IsWidgetDeserializableVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.endsWith(".json")) {
                try {
                    this.objectMapper.fromJson(Files.readAllBytes(file), Widget.class);
                }
                catch (Exception e) {
                    Assertions.fail((String)(file.getFileName() + " cannot be deserialized to Widget model"), (Throwable)e);
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

