/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.fragment;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonViewLight;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.utils.ListUtil;
import org.bonitasoft.web.designer.visitor.HtmlBuilderVisitor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.skyscreamer.jsonassert.JSONAssert;

@RunWith(value=MockitoJUnitRunner.class)
public class FragmentTest {
    private ObjectMapper objectMapper = new DesignerConfig().objectMapper();
    @Mock
    FragmentRepository fragmentRepository;
    @InjectMocks
    HtmlBuilderVisitor htmlBuilder;

    @Test
    public void jsonview_light_should_only_manage_id_name_hasValidationErrors_and_light_page() throws Exception {
        String json = this.objectMapper.writerWithView(JsonViewLight.class).writeValueAsString((Object)this.createAFilledFragment());
        System.out.println("json : " + json);
        JSONAssert.assertEquals((String)json, (String)"{\"id\":\"ID\",\"name\":\"name\",\"type\":\"fragment\",\"favorite\":false,\"hasValidationError\":false,\"status\": {\"compatible\":true, \"migration\":true},\"usedBy\":{\"page\":[{\"id\":\"ID\",\"uuid\":\"UUID\",\"name\":\"myPage\",\"type\":\"page\", \"favorite\":false, \"hasValidationError\":false, \"status\": {\"compatible\":true, \"migration\":true}}],\"fragment\":[{\"id\":\"ID\",\"name\":\"father\",\"type\":\"fragment\", \"favorite\":true, \"hasValidationError\":false, \"status\": {\"compatible\":true, \"migration\":true}}]}}", (boolean)true);
    }

    @Test
    public void jsonview_persistence_should_manage_all_fields_pages() throws Exception {
        Fragment fragmentInitial = this.createAFilledFragment();
        fragmentInitial.addVariable("aDAta", new Variable(DataType.CONSTANT, "aConstant"));
        Fragment fragmentAfterJsonProcessing = (Fragment)this.objectMapper.readValue(this.objectMapper.writerWithView(JsonViewPersistence.class).writeValueAsString((Object)fragmentInitial), Fragment.class);
        Assertions.assertThat((String)fragmentAfterJsonProcessing.getName()).isNotNull();
        Assertions.assertThat((String)fragmentAfterJsonProcessing.getId()).isNotNull();
        Assertions.assertThat((Map)fragmentAfterJsonProcessing.getVariables()).isNotEmpty();
        Assertions.assertThat((List)fragmentAfterJsonProcessing.getRows()).isNotNull();
        Assertions.assertThat((Map)fragmentAfterJsonProcessing.getUsedBy()).isNull();
    }

    private Fragment createAFilledFragment() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("ID").withName("father").favorite().build();
        Fragment fragmentSon = FragmentBuilder.aFragment().id("ID").withName("name").build();
        Page page = PageBuilder.aFilledPage("ID");
        page.setUUID("UUID");
        page.setName("myPage");
        fragmentSon.addUsedBy("page", ListUtil.asList(new Identifiable[]{page}));
        fragmentSon.addUsedBy("fragment", ListUtil.asList(new Identifiable[]{fragment}));
        return fragmentSon;
    }

    @Test
    public void should_not_add_useBy_components_when_list_is_empty() throws Exception {
        Fragment fragment = new Fragment();
        fragment.addUsedBy("component", new ArrayList());
        Assertions.assertThat((Map)fragment.getUsedBy()).isNull();
    }

    @Test
    public void should_not_add_useBy_components_when_list_is_null() throws Exception {
        Fragment fragment = new Fragment();
        fragment.addUsedBy("component", null);
        Assertions.assertThat((Map)fragment.getUsedBy()).isNull();
    }

    @Test
    public void should_not_add_useBy_components() throws Exception {
        Page page = PageBuilder.aPage().build();
        Fragment fragment = new Fragment();
        fragment.addUsedBy("component", ListUtil.asList(new Identifiable[]{page}));
        Assertions.assertThat((List)((List)fragment.getUsedBy().get("component"))).containsOnly((Object[])new Identifiable[]{page});
    }
}

