/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.rendering;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.rendering.GenerationException;
import org.bonitasoft.web.designer.rendering.Minifier;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MinifierTest {
    @Test
    public void should_minify_input() throws IOException {
        String content = "function PbInputCtrl($scope, $log, widgetNameFactory) {\n\n'use strict';\n\n  this.name = widgetNameFactory.getName('pbInput');\n\n  if (!$scope.properties.isBound('value')) {\n    $log.error('the pbInput property named \"value\" need to be bound to a variable');\n  }\n}\n";
        String expected = "\nfunction PbInputCtrl($scope,$log,widgetNameFactory){'use strict';this.name=widgetNameFactory.getName('pbInput');if(!$scope.properties.isBound('value')){$log.error('the pbInput property named \"value\" need to be bound to a variable');}}";
        byte[] min = Minifier.minify((byte[])content.getBytes());
        Assertions.assertThat((String)new String(min, "UTF-8")).isEqualTo((Object)expected);
    }

    @Test(expected=GenerationException.class)
    public void should_throw_exeption_when_content_have_bad_unterminated_comment() throws IOException {
        String badCommentTemplate = "/** dffsf /";
        String content = badCommentTemplate + "content";
        Minifier.minify((byte[])content.getBytes());
    }

    @Test(expected=GenerationException.class)
    public void should_throw_exeption_when_content_have_bad_unterminated_string() throws IOException {
        String unterminatedString = "'use strict\n";
        String content = "function PbInputCtrl($scope, $log, widgetNameFactory) { \n" + unterminatedString;
        Minifier.minify((byte[])content.getBytes());
    }
}

