/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.rendering;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.rendering.GenerationException;
import org.bonitasoft.web.designer.rendering.TemplateEngine;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TemplateEngineTest {
    @Test
    public void should_load_template_from_classpath() throws GenerationException {
        TemplateEngine template = new TemplateEngine("template.html");
        Assertions.assertThat((String)template.build(Collections.singletonMap("variable", "foobar"))).isEqualTo((Object)"<div>foobar</div>");
    }

    @Test
    public void should_allow_using_json_in_templates() throws GenerationException {
        TemplateEngine template = new TemplateEngine("json-template.html");
        Bar bar = new Bar();
        bar.setVariable("qux");
        Assertions.assertThat((String)template.build(Collections.singletonMap("variable", bar))).isEqualTo((Object)"<div>{\"variable\":\"qux\"}</div>");
    }

    @Test
    public void should_allow_using_object_properties_in_templates() throws GenerationException {
        TemplateEngine template = new TemplateEngine("template.html");
        Bar bar = new Bar();
        bar.setVariable("baz");
        Assertions.assertThat((String)template.build((Object)bar)).isEqualTo((Object)"<div>baz</div>");
    }

    @Test
    public void should_let_add_extra_variable_to_the_template_context() throws GenerationException {
        TemplateEngine template = new TemplateEngine("template.html");
        Assertions.assertThat((String)template.with("variable", (Object)"bazqux").build(null)).isEqualTo((Object)"<div>bazqux</div>");
    }

    @Test
    public void should_displayData_when_ifequal_value_is_true() throws GenerationException {
        TemplateEngine template = new TemplateEngine("ifequal-template.html");
        Assertions.assertThat((String)template.with("variable", (Object)"JAVASCRIPT").build(null)).isEqualTo((Object)"JAVASCRIPT");
    }

    @Test
    public void should_not_displayData_when_ifequal_value_is_false() throws GenerationException {
        TemplateEngine template = new TemplateEngine("ifequal-template.html");
        Assertions.assertThat((String)template.with("variable", (Object)"PAJAVASCRIPT").build(null)).isEmpty();
    }

    class Bar {
        private String variable;

        Bar() {
        }

        public void setVariable(String variable) {
            this.variable = variable;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

