/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.rendering;

import java.io.File;
import java.nio.file.Path;
import org.bonitasoft.web.designer.rendering.GenerationException;
import org.bonitasoft.web.designer.rendering.WidgetFileHelper;
import org.bonitasoft.web.designer.utils.assertions.CustomAssertions;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Rule;
import org.junit.Test;

public class WidgetFileHelperTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void should_write_content_at_path() throws Exception {
        byte[] content = "Mon content".getBytes();
        Path path = WidgetFileHelper.writeFile((byte[])content, (Path)this.temporaryFolder.toPath(), (String)"f8a4574");
        CustomAssertions.assertThat((File)path.toFile()).exists();
        CustomAssertions.assertThat((String)path.getFileName().toString()).isEqualTo((Object)"widgets-f8a4574.js");
    }

    @Test
    public void should_delete_on_folder_all_old_widgets_directives_file() throws Exception {
        File assetsFolder = this.temporaryFolder.newFolder(new String[]{"maPage", "assets"});
        File expectToBeDeletedFile = this.temporaryFolder.newFile("maPage/assets/widgets-fdsf45741sf.min.js");
        File fragment = this.temporaryFolder.newFile("maPage/assets/123456.js");
        File expectExistFile = this.temporaryFolder.newFile("maPage/assets/12345654.json");
        WidgetFileHelper.deleteOldConcatenateFiles((Path)assetsFolder.toPath(), (String)"aa");
        CustomAssertions.assertThat((File)expectToBeDeletedFile).doesNotExist();
        CustomAssertions.assertThat((File)expectExistFile).exists();
        CustomAssertions.assertThat((File)fragment).exists();
    }

    @Test
    public void should_delete_on_root_folder_all_old_widgets_directives_file() throws Exception {
        File assetsFolder = this.temporaryFolder.newFolder("myFragmentId");
        File fragmentJS = this.temporaryFolder.newFile("myFragmentId/myFragmentId.js");
        File oldConcatDirectiveFile = this.temporaryFolder.newFile("myFragmentId/widgets-11111.min.js");
        File descriptorFile = this.temporaryFolder.newFile("myFragmentId/myFragmentId.json");
        WidgetFileHelper.deleteOldConcatenateFiles((Path)assetsFolder.toPath(), (String)"123");
        CustomAssertions.assertThat((File)fragmentJS).exists();
        CustomAssertions.assertThat((File)descriptorFile).exists();
        CustomAssertions.assertThat((File)oldConcatDirectiveFile).doesNotExist();
    }

    @Test(expected=GenerationException.class)
    public void should_throw_generation_exception_if_not_exist_folder_path_when_write_a_file() throws Exception {
        Path unexistingFile = this.temporaryFolder.toPath().resolve("FileNotFound");
        WidgetFileHelper.writeFile((byte[])"Mon content".getBytes(), (Path)unexistingFile, (String)"notUsedForThisTest");
    }

    @Test(expected=GenerationException.class)
    public void should_throw_generation_exception_if_not_exist_folder_path_dont_exist_when_delete_a_file() throws Exception {
        Path folderNotFound = this.temporaryFolder.toPath().resolve("folderNotFound");
        WidgetFileHelper.deleteOldConcatenateFiles((Path)folderNotFound, (String)"notUsedForThisTest");
    }

    @Test
    public void should_delete_files_if_old_files_exists() throws Exception {
        File assetsFolder = this.temporaryFolder.newFolder(new String[]{"maPage", "assets"});
        File expectFileDeleted = this.temporaryFolder.newFile("maPage/assets/widgets-4576.min.js");
        File expectFileAlreadyExist = this.temporaryFolder.newFile("maPage/assets/widgets-1z2a3456.min.js");
        WidgetFileHelper.deleteOldConcatenateFiles((Path)assetsFolder.toPath(), (String)"1z2a3456");
        CustomAssertions.assertThat((File)expectFileDeleted).doesNotExist();
        CustomAssertions.assertThat((File)expectFileAlreadyExist).exists();
    }

    @Test
    public void should_delete_files_if_exists() throws Exception {
        File assetsFolder = this.temporaryFolder.newFolder(new String[]{"maPage", "js"});
        File expectFileDeleted = this.temporaryFolder.newFile("maPage/js/widgets-4576.min.js");
        WidgetFileHelper.deleteConcatenateFile((Path)assetsFolder.toPath());
        CustomAssertions.assertThat((File)expectFileDeleted).doesNotExist();
    }
}

