/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PropertyBuilder;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.service.BondsTypesFixer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BondsTypesFixerTest {
    @Mock
    public PageRepository pageRepository;
    @InjectMocks
    public BondsTypesFixer bondsTypesFixer;

    @Test
    public void should_fix_bonds_types_in_all_pages() throws Exception {
        Component labelComponent = (Component)ComponentBuilder.aComponent("labelComponent").withPropertyValue("text", "constant", "").build();
        Page page = PageBuilder.aPage().with(new Element[]{labelComponent}).build();
        Mockito.when((Object)this.pageRepository.findByObjectId("labelWidget")).thenReturn(Collections.singletonList(page));
        this.bondsTypesFixer.fixBondsTypes("labelWidget", Collections.singletonList(PropertyBuilder.aProperty().name("text").bond(BondType.INTERPOLATION).build()));
        Assertions.assertThat((String)((PropertyValue)labelComponent.getPropertyValues().get("text")).getType()).isEqualTo((Object)BondType.INTERPOLATION.toJson());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).save((Identifiable)page);
    }
}

