/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Set;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.visitor.AuthRulesCollector;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthRulesCollectorTest {
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private AuthRulesCollector authRulesCollector;

    private Component mockComponentFor(WidgetBuilder widgetBuilder) throws Exception {
        Widget widget = widgetBuilder.build();
        Component component = ComponentBuilder.aComponent().withWidgetId(widget.getId()).build();
        Mockito.when((Object)this.widgetRepository.get(component.getId())).thenReturn((Object)widget);
        return component;
    }

    @Test
    public void should_return_collect_nothing_when_page_does_not_contain_any_widget_with_auth_rules() throws Exception {
        Component component = this.mockComponentFor(WidgetBuilder.aWidget());
        Page page = PageBuilder.aPage().with(new Element[]{component}).build();
        Set modules = this.authRulesCollector.visit((Previewable)page);
        Assertions.assertThat((Iterable)modules).isEmpty();
    }

    @Test
    public void should_collect_auth_rules_needed_by_widgets() throws Exception {
        Component component = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|living/application-menu", "POST|bpm/process"));
        Set modules = this.authRulesCollector.visit(component);
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"GET|living/application-menu", "POST|bpm/process"});
    }

    @Test
    public void should_collect_auth_rules_needed_by_widgets_in_container() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|living/application-menu", "POST|bpm/process"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|bpm/userTask"));
        Set modules = this.authRulesCollector.visit(ContainerBuilder.aContainer().with(new Element[]{component1, component2}).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"GET|living/application-menu", "POST|bpm/process", "GET|bpm/userTask"});
    }

    @Test
    public void should_collect_auth_rules_needed_by_widgets_in_formcontainer() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|living/application-menu", "POST|bpm/process"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|bpm/userTask"));
        Set modules = this.authRulesCollector.visit(FormContainerBuilder.aFormContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1, component2})).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"GET|living/application-menu", "POST|bpm/process", "GET|bpm/userTask"});
    }

    @Test
    public void should_collect_auth_rules_needed_by_widgets_in_tabscontainer() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|living/application-menu", "POST|bpm/process"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|bpm/userTask"));
        Set modules = this.authRulesCollector.visit(TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1})), TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{component2}))).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"GET|living/application-menu", "POST|bpm/process", "GET|bpm/userTask"});
    }

    @Test
    public void should_collect_auth_rules_needed_by_widgets_in_previewable() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|living/application-menu", "POST|bpm/process"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|bpm/userTask"));
        Set modules = this.authRulesCollector.visit((Previewable)PageBuilder.aPage().with(new Element[]{component1, component2}).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"GET|living/application-menu", "POST|bpm/process", "GET|bpm/userTask"});
    }

    @Test
    public void should_collect_auth_rules_needed_by_widgets_in_modal_container() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|living/application-menu", "POST|bpm/process"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|bpm/userTask"));
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set modules = this.authRulesCollector.visit(ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1, component2})).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"GET|living/application-menu", "POST|bpm/process", "GET|bpm/userTask"});
    }

    @Test
    public void should_collect_auth_rules_needed_by_widgets_in_fragment() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|living/application-menu", "POST|bpm/process"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().authRules("GET|bpm/userTask"));
        FragmentElement fragmentElement = FragmentElementBuilder.aFragmentElement().withFragmentId("my-fragment").build();
        Fragment fragment = FragmentBuilder.aFragment().id("my-fragment").with(new Element[]{component1, component2}).build();
        Mockito.when((Object)this.fragmentRepository.get(fragmentElement.getId())).thenReturn((Object)fragment);
        Set modules = this.authRulesCollector.visit((Previewable)fragment);
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"GET|living/application-menu", "POST|bpm/process", "GET|bpm/userTask"});
    }
}

