/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ComponentVisitorTest {
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private ComponentVisitor componentVisitor;
    private Component component;

    @Before
    public void setUp() throws Exception {
        this.component = ComponentBuilder.aComponent().build();
    }

    @Test
    public void should_collect_component_when_visiting_a_component() throws Exception {
        Iterable components = this.componentVisitor.visit(this.component);
        Assertions.assertThat((Iterable)components).containsExactly((Object[])new Component[]{this.component});
    }

    @Test
    public void should_collect_component_from_a_container() throws Exception {
        Iterable components = this.componentVisitor.visit(ContainerBuilder.aContainer().with(new Element[]{this.component}).build());
        Assertions.assertThat((Iterable)components).containsExactly((Object[])new Component[]{this.component});
    }

    @Test
    public void should_collect_component_from_a_tabs_container() throws Exception {
        Iterable components = this.componentVisitor.visit(TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{this.component}))).build());
        Assertions.assertThat((Iterable)components).containsExactly((Object[])new Component[]{this.component});
    }

    @Test
    public void should_collect_component_from_a_formcontainer() throws Exception {
        Iterable components = this.componentVisitor.visit(FormContainerBuilder.aFormContainer().with(ContainerBuilder.aContainer().with(new Element[]{this.component}).build()).build());
        Assertions.assertThat((Iterable)components).containsExactly((Object[])new Component[]{this.component});
    }

    @Test
    public void should_collect_component_from_a_previewable() throws Exception {
        Iterable components = this.componentVisitor.visit((Previewable)PageBuilder.aPage().with(new Element[]{this.component}).build());
        Assertions.assertThat((Iterable)components).containsExactly((Object[])new Component[]{this.component});
    }

    @Test
    public void should_collect_component_from_a_modal_container() throws Exception {
        Iterable components = this.componentVisitor.visit(ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{this.component})).build());
        Assertions.assertThat((Iterable)components).containsExactly((Object[])new Component[]{this.component});
    }

    @Test
    public void should_collect_component_from_a_fragment() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenReturn((Object)FragmentBuilder.aFragment().with(new Element[]{this.component}).build());
        Iterable components = this.componentVisitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").build());
        Assertions.assertThat((Iterable)components).containsExactly((Object[])new Component[]{this.component});
    }
}

