/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.RowBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.visitor.FragmentIdVisitor;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FragmentIdVisitorTest {
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private FragmentIdVisitor fragmentIdVisitor;

    @Before
    public void setUp() {
        Mockito.when((Object)this.fragmentRepository.get(Matchers.anyString())).thenReturn((Object)FragmentBuilder.aFragment().build());
    }

    @Test
    public void should_add_fragment_id_to_visited_fragment_ids_when_visiting_fragment() throws Exception {
        FragmentElement fragmentElement = FragmentElementBuilder.aFragmentElement().withFragmentId("aFragmentId").build();
        Assertions.assertThat((Iterable)this.fragmentIdVisitor.visit(fragmentElement)).containsOnly((Object[])new String[]{"aFragmentId"});
    }

    @Test
    public void should_visit_each_container_rows() throws Exception {
        Container container = ContainerBuilder.aContainer().with(RowBuilder.aRow().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment1")), RowBuilder.aRow().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment2"))).build();
        Assertions.assertThat((Iterable)this.fragmentIdVisitor.visit(container)).containsOnly((Object[])new String[]{"fragment1", "fragment2"});
    }

    @Test
    public void should_visit_formcontainer() throws Exception {
        Container container = ContainerBuilder.aContainer().with(RowBuilder.aRow().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment1")), RowBuilder.aRow().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment2"))).build();
        Assertions.assertThat((Iterable)this.fragmentIdVisitor.visit(FormContainerBuilder.aFormContainer().with(container).build())).containsOnly((Object[])new String[]{"fragment1", "fragment2"});
    }

    @Test
    public void should_visit_each_tabsContainer_containers() throws Exception {
        TabsContainer tabsContainer = TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment3"))), TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment4")))).build();
        Assertions.assertThat((Iterable)this.fragmentIdVisitor.visit(tabsContainer)).containsOnly((Object[])new String[]{"fragment3", "fragment4"});
    }

    @Test
    public void should_visit_each_modal_container_rows() throws Exception {
        ModalContainer modalContainer = ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(RowBuilder.aRow().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment5")), RowBuilder.aRow().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment6")))).build();
        Assertions.assertThat((Iterable)this.fragmentIdVisitor.visit(modalContainer)).containsOnly((Object[])new String[]{"fragment5", "fragment6"});
    }

    @Test
    public void should_visit_fragment_container_when_visiting_a_fragment_element() throws Exception {
        FragmentElement fragmentElement = FragmentElementBuilder.aFragmentElement().withFragmentId("aFragmentId").build();
        Fragment fragment = FragmentBuilder.aFragment().with(RowBuilder.aRow().with(FragmentElementBuilder.aFragmentElement().withFragmentId("anotherFragmentId"))).build();
        Mockito.when((Object)this.fragmentRepository.get(fragmentElement.getId())).thenReturn((Object)fragment);
        Assertions.assertThat((Iterable)this.fragmentIdVisitor.visit(fragmentElement)).containsOnly((Object[])new String[]{"aFragmentId", "anotherFragmentId"});
    }

    @Test
    public void should_do_noting_when_visiting_a_component() throws Exception {
        Assertions.assertThat((Iterable)this.fragmentIdVisitor.visit(new Component())).isEmpty();
    }
}

