/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PropertyValueBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ParameterType;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.rendering.TemplateEngine;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.visitor.ModelPropertiesVisitor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ModelPropertiesVisitorTest {
    @Mock
    FragmentRepository fragmentRepository;
    @InjectMocks
    ModelPropertiesVisitor modelPropertiesVisitor;
    FragmentElement person = (FragmentElement)FragmentElementBuilder.aFragmentElement().withFragmentId("person").withBinding("foo", "bar").withReference("person").build();
    FragmentElement address = (FragmentElement)FragmentElementBuilder.aFragmentElement().withFragmentId("address").withBinding("baz", "qux").withReference("address").build();

    @Test
    public void should_generate_a_model_properties_factory() throws Exception {
        this.mock(FragmentBuilder.aFragment().id("address").withVariable("baz", VariableBuilder.aConstantVariable().exposed(true)));
        this.mock(FragmentBuilder.aFragment().id("person").withVariable("foo", VariableBuilder.aConstantVariable().exposed(true)).with(ContainerBuilder.aContainer().with(new Element[]{this.address})));
        Page page = PageBuilder.aPage().with(ContainerBuilder.aContainer().with(new Element[]{this.person})).build();
        String generated = this.modelPropertiesVisitor.generate((Previewable)page);
        Assertions.assertThat((String)generated).isEqualTo((Object)new TemplateEngine("factory.hbs.js").with("name", (Object)"modelProperties").with("resources", (Object)ImmutableMap.of((Object)"person", this.createProperty("foo", "bar"), (Object)"address", this.createProperty("baz", "qux"))).build((Object)this));
    }

    @Test
    public void should_retrieve_nested_fragments_model_properties_for_exposed_variable() throws Exception {
        this.mock(FragmentBuilder.aFragment().id("address").withVariable("baz", VariableBuilder.aConstantVariable().exposed(true)));
        this.mock(FragmentBuilder.aFragment().id("person").withVariable("foo", VariableBuilder.aConstantVariable().exposed(true)).with(ContainerBuilder.aContainer().with(new Element[]{this.address})));
        Page page = PageBuilder.aPage().with(ContainerBuilder.aContainer().with(new Element[]{this.person})).build();
        Map bindings = this.modelPropertiesVisitor.visit((Previewable)page);
        Assertions.assertThat((Map)bindings).contains(new Map.Entry[]{Assertions.entry((Object)"person", this.createProperty("foo", "bar"))});
        Assertions.assertThat((Map)bindings).contains(new Map.Entry[]{Assertions.entry((Object)"address", this.createProperty("baz", "qux"))});
    }

    @Test
    public void should_not_retrieve_bindings_for_not_exposed_variable() throws Exception {
        this.mock(FragmentBuilder.aFragment().id("address").withVariable("baz", VariableBuilder.aConstantVariable().exposed(false)));
        this.mock(FragmentBuilder.aFragment().id("person").withVariable("foo", VariableBuilder.aConstantVariable().exposed(false)).with(ContainerBuilder.aContainer().with(new Element[]{this.address})));
        Page page = PageBuilder.aPage().with(ContainerBuilder.aContainer().with(new Element[]{this.person})).build();
        Map bindings = this.modelPropertiesVisitor.visit((Previewable)page);
        Assertions.assertThat((Map)bindings).contains(new Map.Entry[]{Assertions.entry((Object)"person", this.emptyMap())});
        Assertions.assertThat((Map)bindings).contains(new Map.Entry[]{Assertions.entry((Object)"address", this.emptyMap())});
    }

    @Test
    public void should_retrieve_nested_fragments_model_properties_for_exposed_variable_with_a_modal_container() throws Exception {
        this.mock(FragmentBuilder.aFragment().id("address").withVariable("baz", VariableBuilder.aConstantVariable().exposed(true)));
        this.mock(FragmentBuilder.aFragment().id("person").withVariable("foo", VariableBuilder.aConstantVariable().exposed(true)).with(new Element[]{ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{this.address})).build()}));
        Page page = PageBuilder.aPage().with(ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{this.person}))).build();
        Map bindings = this.modelPropertiesVisitor.visit((Previewable)page);
        Assertions.assertThat((Map)bindings).contains(new Map.Entry[]{Assertions.entry((Object)"person", this.createProperty("foo", "bar"))});
        Assertions.assertThat((Map)bindings).contains(new Map.Entry[]{Assertions.entry((Object)"address", this.createProperty("baz", "qux"))});
    }

    private void mock(FragmentBuilder fragmentBuilder) {
        Fragment fragment = fragmentBuilder.build();
        Mockito.when((Object)this.fragmentRepository.get(fragment.getId())).thenReturn((Object)fragment);
    }

    private ImmutableMap<String, PropertyValue> createProperty(String name, String value) {
        PropertyValue propertyValue = PropertyValueBuilder.aPropertyValue().withType(ParameterType.VARIABLE).withValue(value).build();
        return ImmutableMap.of((Object)name, (Object)propertyValue);
    }

    private Map<String, PropertyValue> emptyMap() {
        return Maps.newHashMap();
    }
}

