/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.rendering.GenerationException;
import org.bonitasoft.web.designer.rendering.TemplateEngine;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.visitor.VariableModelVisitor;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class VariableModelVisitorTest {
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private VariableModelVisitor variableModelVisitor;
    private Variable variable;

    @Before
    public void setUp() throws Exception {
        this.variable = VariableBuilder.aConstantVariable().value("bar").build();
    }

    @Test
    public void should_not_retrieve_any_variable_model_when_visiting_a_component() throws Exception {
        Assertions.assertThat((Map)this.variableModelVisitor.visit(ComponentBuilder.aComponent().build())).isEmpty();
    }

    @Test
    public void should_retrieve_variable_model_from_page() throws Exception {
        Page page = PageBuilder.aPage().withId("page-id").withVariable("foo", this.variable).build();
        Assertions.assertThat((Map)this.variableModelVisitor.visit((Previewable)page)).containsExactly(new Map.Entry[]{Assertions.entry((Object)"page-id", Collections.singletonMap("foo", this.variable))});
    }

    @Test
    public void should_generate_a_factory_based_on_model_found_in_the_page() throws Exception {
        Page page = PageBuilder.aPage().withId("page-id").withVariable("foo", this.variable).build();
        Assertions.assertThat((String)this.variableModelVisitor.generate((Previewable)page)).isEqualTo((Object)new TemplateEngine("factory.hbs.js").with("name", (Object)"variableModel").with("resources", Collections.singletonMap("page-id", Collections.singletonMap("foo", this.variable))).build((Object)this));
    }

    @Test
    public void should_retrieve_data_model_from_fragment() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenReturn((Object)FragmentBuilder.aFragment().id("fragment-id").withVariable("foo", this.variable).build());
        Assertions.assertThat((Map)this.variableModelVisitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").build())).containsExactly(new Map.Entry[]{Assertions.entry((Object)"fragment-id", Collections.singletonMap("foo", this.variable))});
    }

    @Test(expected=GenerationException.class)
    public void should_throw_a_generation_error_when_the_fragment_is_not_found() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenThrow(new Throwable[]{new NotFoundException("")});
        this.variableModelVisitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").build());
    }

    @Test(expected=GenerationException.class)
    public void should_throw_a_generation_error_when_an_error_occur_in_the_fragment_repository() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenThrow(new Throwable[]{new GenerationException("", (Throwable)new RuntimeException())});
        this.variableModelVisitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").build());
    }

    @Test
    public void should_retrieve_variable_model_from_a_container_content() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenReturn((Object)FragmentBuilder.aFragment().id("fragment-id").withVariable("foo", this.variable).build());
        Assertions.assertThat((Map)this.variableModelVisitor.visit(ContainerBuilder.aContainer().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id")).build())).containsExactly(new Map.Entry[]{Assertions.entry((Object)"fragment-id", Collections.singletonMap("foo", this.variable))});
    }

    @Test
    public void should_retrieve_variable_model_from_a_tabs_container_content() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenReturn((Object)FragmentBuilder.aFragment().id("fragment-id").withVariable("foo", this.variable).build());
        Assertions.assertThat((Map)this.variableModelVisitor.visit(TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id")))).build())).containsExactly(new Map.Entry[]{Assertions.entry((Object)"fragment-id", Collections.singletonMap("foo", this.variable))});
    }

    @Test
    public void should_generate_a_factory_with_fragment() throws Exception {
        HashMap<String, Map<String, Variable>> variableModel = new HashMap<String, Map<String, Variable>>();
        variableModel.put("page-id", Collections.singletonMap("foo", this.variable));
        variableModel.put("fragment-id", Collections.singletonMap("baz", this.variable));
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenReturn((Object)FragmentBuilder.aFragment().id("fragment-id").withVariable("baz", this.variable).build());
        String factory = this.variableModelVisitor.generate((Previewable)PageBuilder.aPage().withId("page-id").withVariable("foo", this.variable).with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id")).build());
        Assertions.assertThat((String)factory).isEqualTo((Object)new TemplateEngine("factory.hbs.js").with("name", (Object)"variableModel").with("resources", variableModel).build((Object)this));
    }
}

